/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.Connection;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.Logger;
import Ice.MarshalException;
import Ice.NoEndpointException;
import IceInternal.BasicStream;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.Reference;
import IceInternal.RoutableReference;
import IceInternal.RouterInfo;
import IceInternal.TraceLevels;
import IceUtil.StringUtil;
import java.util.Hashtable;

public class IndirectReference
extends RoutableReference {
    private String _adapterId;
    private LocatorInfo _locatorInfo;

    public IndirectReference(Instance instance, Communicator communicator, Identity identity, Hashtable hashtable, String string, int n, boolean bl, String string2, RouterInfo routerInfo, LocatorInfo locatorInfo) {
        super(instance, communicator, identity, hashtable, string, n, bl, routerInfo);
        this._adapterId = string2;
        this._locatorInfo = locatorInfo;
    }

    public final String getAdapterId() {
        return this._adapterId;
    }

    public final LocatorInfo getLocatorInfo() {
        return this._locatorInfo;
    }

    public Endpoint[] getEndpoints() {
        return new Endpoint[0];
    }

    public Reference changeLocator(LocatorPrx locatorPrx) {
        if (locatorPrx == null) {
            return this.getInstance().referenceFactory().create(this.getIdentity(), this.getContext(), this.getFacet(), this.getMode(), this.getSecure(), new Endpoint[0], this.getRouterInfo());
        }
        LocatorInfo locatorInfo = this.getInstance().locatorManager().get(locatorPrx);
        if (locatorInfo == this._locatorInfo || this._locatorInfo != null && locatorInfo != null && locatorInfo.equals(this._locatorInfo)) {
            return this;
        }
        IndirectReference indirectReference = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        indirectReference._locatorInfo = locatorInfo;
        return this;
    }

    public Reference changeTimeout(int n) {
        IndirectReference indirectReference = (IndirectReference)this.getInstance().referenceFactory().copy(this);
        if (this._locatorInfo != null) {
            LocatorPrx locatorPrx = LocatorPrxHelper.uncheckedCast(this._locatorInfo.getLocator().ice_timeout(n));
            indirectReference._locatorInfo = this.getInstance().locatorManager().get(locatorPrx);
        }
        return indirectReference;
    }

    public void streamWrite(BasicStream basicStream) throws MarshalException {
        super.streamWrite(basicStream);
        basicStream.writeSize(0);
        basicStream.writeString(this._adapterId);
    }

    public String toString() {
        String string = super.toString();
        if (this._adapterId.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(" @ ");
        String string2 = StringUtil.escapeString(this._adapterId, null);
        if (StringUtil.findFirstOf(string2, " \t\n\r") != -1) {
            stringBuffer.append('\"');
            stringBuffer.append(string2);
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public Connection getConnection() {
        Connection connection;
        while (true) {
            Endpoint[] endpointArray;
            Endpoint[] endpointArray2 = super.getRoutedEndpoints();
            BooleanHolder booleanHolder = new BooleanHolder(false);
            if (endpointArray2.length == 0 && this._locatorInfo != null) {
                endpointArray2 = this._locatorInfo.getEndpoints(this, booleanHolder);
            }
            if ((endpointArray = this.filterEndpoints(endpointArray2)).length == 0) {
                NoEndpointException noEndpointException = new NoEndpointException();
                noEndpointException.proxy = this.toString();
                throw noEndpointException;
            }
            try {
                OutgoingConnectionFactory outgoingConnectionFactory = this.getInstance().outgoingConnectionFactory();
                connection = outgoingConnectionFactory.create(endpointArray);
            }
            catch (LocalException localException) {
                if (this.getRouterInfo() == null) {
                    this._locatorInfo.clearCache(this);
                    if (booleanHolder.value) {
                        TraceLevels traceLevels = this.getInstance().traceLevels();
                        Logger logger = this.getInstance().logger();
                        if (traceLevels.retry < 2) continue;
                        String string = "connection to cached endpoints failed\nremoving endpoints from cache and trying one more time\n" + localException;
                        logger.trace(traceLevels.retryCat, string);
                        continue;
                    }
                }
                throw localException;
            }
            break;
        }
        if (this.getRouterInfo() != null) {
            connection.setAdapter(this.getRouterInfo().getAdapter());
        }
        return connection;
    }

    public synchronized int hashCode() {
        if (this._hashInitialized) {
            return this._hashValue;
        }
        super.hashCode();
        int n = this._adapterId.length();
        for (int i = 0; i < n; ++i) {
            this._hashValue = 5 * this._hashValue + this._adapterId.charAt(i);
        }
        return this._hashValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndirectReference)) {
            return false;
        }
        IndirectReference indirectReference = (IndirectReference)object;
        if (!super.equals(indirectReference)) {
            return false;
        }
        if (!this._adapterId.equals(indirectReference._adapterId)) {
            return false;
        }
        return this._locatorInfo == null ? indirectReference._locatorInfo == null : this._locatorInfo.equals(indirectReference._locatorInfo);
    }

    protected IndirectReference() {
    }

    protected void shallowCopy(IndirectReference indirectReference) {
        super.shallowCopy(indirectReference);
        indirectReference._adapterId = this._adapterId;
        indirectReference._locatorInfo = this._locatorInfo;
    }

    public Object ice_clone() {
        IndirectReference indirectReference = new IndirectReference();
        this.shallowCopy(indirectReference);
        return indirectReference;
    }
}

