/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:     yfvinit.c
 * Abstract:        Initialize the vocabulary.
 */

#include <string.h>
#include "yforth.h"
#include "core.h"
#include "ycore.h"
#if COREE_DEF
#	include "coree.h"
#endif
#if DOUBLE_DEF
#	include "double.h"
#endif
#if DOUBLEE_DEF
#	include	"doublee.h"
#endif
#if FLOAT_DEF
#	if !COREE_DEF
#		include "coree.h"
#	endif
#	include "float.h"
#endif
#if FLOATE_DEF
#	include	"floate.h"
#endif
#if MEMALL_DEF
#	include "memall.h"
#endif
#if SEARCH_DEF
#	include "search.h"
#endif
#if SEARCHE_DEF
#	include "searche.h"
#endif
#if TOOLS_DEF
#	include "tools.h"
#endif
#if TOOLSE_DEF
#	if !COREE_DEF
#		include "coree.h"
#	endif
#	include "toolse.h"
#endif
#if LOCALS_DEF
#	include "locals.h"
#endif
#if LOCALSE_DEF
#	include "localse.h"
#endif
#if FACILITY_DEF
#	include "facility.h"
#endif
#if FACILITYE_DEF
#	include "facilite.h"
#endif
#if STRING_DEF
#	include "string.h"
#endif
#if FILE_DEF
#	include "file.h"
#endif
#if	FILEE_DEF
#	include "filee.h"
#endif
#if BLOCK_DEF
#	include "block.h"
#endif
#if BLOCKE_DEF
#	include "blocke.h"
#endif
#if EXCEPTION_DEF
#	include "exceptio.h"
#endif
#if EXCEPTIONE_DEF
#	include "excepte.h"
#endif

static struct raw_voc iv[] = {
#define DECLARE_WORDS

#include "core.h"
#include "ycore.h"
#if COREE_DEF
#	include "coree.h"
#endif
#if DOUBLE_DEF
#	include "double.h"
#endif
#if DOUBLEE_DEF
#	include	"doublee.h"
#endif
#if FLOAT_DEF
#	include "float.h"
#endif
#if FLOATE_DEF
#	include	"floate.h"
#endif
#if MEMALL_DEF
#	include "memall.h"
#endif
#if SEARCH_DEF
#	include "search.h"
#endif
#if SEARCHE_DEF
#	include "searche.h"
#endif
#if TOOLS_DEF
#	include "tools.h"
#endif
#if TOOLSE_DEF
#	include "toolse.h"
#endif
#if LOCALS_DEF
#	include "locals.h"
#endif
#if LOCALSE_DEF
#	include "localse.h"
#endif
#if FACILITY_DEF
#	include "facility.h"
#endif
#if FACILITYE_DEF
#	include "facilite.h"
#endif
#ifdef STRING_DEF
#	include "string.h"
#endif
#if FILE_DEF
#	include "file.h"
#endif
#if	FILEE_DEF
#	include "filee.h"
#endif
#if BLOCK_DEF
#	include "block.h"
#endif
#if BLOCKE_DEF
#	include "blocke.h"
#endif
#if EXCEPTION_DEF
#	include "exceptio.h"
#endif
#if EXCEPTIONE_DEF
#	include "excepte.h"
#endif

	{ 0, 0, 0 },
};

#undef DECLARE_WORDS

/* init_vocabulary: loads words into the real dictionary from the table
 * builded by including all the header files after the declaration of
 * DECLARE_WORDS. See the header files such as "core.h" and the macro
 * file "macro.h" for the implementation of this.
 * This function returns the dictionary pointer after loading.
 */
void init_vocabulary(Char **dp) {
	struct word_def *w;
	Char *name;
	int i = 0;
    while (iv[i].name) {                /* Last name is a NULL (see table above) */
        name = *dp;                     /* "name" is a ptr to the name */
        **dp = strlen(iv[i].name);      /* first copy length... */
        strcpy(*dp + 1, iv[i].name);    /* ...and then the actual name */
        *dp = (Char *) WORD_PTR(*dp);   /* advance "dp" */
        w = (struct word_def *) *dp;    /* here begins the structure */
        w->name = name;                 /* adjust pointer... */
        w->class = iv[i].class;         /* ...and the class of the word */
        ins_word(w);                    /* Finally adjust the link field... */
        mark_word(w);                   /* ...accordingly with the hash function
                                           and make the word visible */
        *dp += sizeof(struct word_def); /* advance "dp" */
        switch (iv[i].class & A_WORD) {     /* The last field must be adjusted here */
			case A_PRIMITIVE:
				w->func[0] = iv[i].func;
				break;
			case A_USER:
				w->func[0] = (pfp) iv[i].func;
				break;
		}
		i++;
	}
}

