/*
 *  update-cluster-parseconfig.c / parse configuration file for update-cluster.
 *  Copyright 2001 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * portions of code taken from expat example code.
 * Original copyright notice follows: 
 */
/* $Id: update-cluster-parseconfig.c,v 1.7 2001/08/08 07:16:46 dancer Exp $ */
/*****************************************************************
 * outline.c
 *
 * Copyright 1999, Clark Cooper
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the license contained in the
 * COPYING file that comes with the expat distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Read an XML document from standard input and print an element
 * outline on standard output.
 */

#include <stdio.h>
#include <expat.h>
#include <string.h>

#define BUFFSIZE 8192
const int depth_cluster = 1;
const int depth_host = 2;
const int depth_elements = 3;

typedef struct assoclist
{
  char * topic;
  char * content;  
  struct assoclist * next;
}assoclist;  


static char Buff[BUFFSIZE];
static int Depth ;
static char * current_node;
static assoclist * list_of_hostinfo = NULL;
static char ** global_av;
static int global_ac;



static void 
outofmemory(void)
{
  fprintf(stderr, "Out of memory\n");
  exit (EXIT_FAILURE);
}

void
start(void *data, const char *el, const char **attr)
{
  Depth++;

  if (Depth == depth_elements)
    current_node = strdup(el);
  if (Depth == depth_host)
    list_of_hostinfo = NULL;
}  /* End of start handler */

void
end(void *data, const char *el) {
  if (Depth == depth_elements)
    free (current_node);
  if (Depth == depth_host)
    {
      assoclist * tmp ;
      int i;
				/* print out one line of space-delimited data */
      for (i=1; i < global_ac; ++i)
	{
	  int found = 0;	  
	  tmp = list_of_hostinfo;
	  
	  while (tmp)
	    {
	      if (!strcmp(tmp->topic, global_av[i]))
		{
		  printf("%s ", tmp->content);
		  found = 1;		  
		  break;		  
		}	      
	      tmp = tmp -> next;	      
	    }
	  if (! found)
	    {
	      fprintf (stderr, "Failed to find a field entry for [%s]\n", 
		       global_av[i]);
	      exit (1);
	    }
	}
      printf ("\n");      
      
      tmp = list_of_hostinfo;
      
      while (list_of_hostinfo)
	{
	  tmp = list_of_hostinfo -> next;
	  free (list_of_hostinfo -> topic);
	  free (list_of_hostinfo -> content);
	  free (list_of_hostinfo);
	  list_of_hostinfo = tmp;
	}
    }  
  Depth--;
}  /* End of end handler */

void
characterhandler (void * userdata, const XML_Char * s, int len)
{
  char * buf ;
  buf = malloc (len+1);
  if (!buf)
    outofmemory();  

  memcpy (buf, s, len);
  buf [len] = 0;
  if (Depth == depth_elements)
    {
      assoclist* tmp = malloc (sizeof (assoclist));
      if (!tmp)
	outofmemory();
      tmp -> topic = strdup (current_node);
      tmp -> content = strdup (buf);
      tmp -> next = list_of_hostinfo;
      list_of_hostinfo = tmp;
    }  
  free ( buf );
}

int
main(int argc, char **argv) 
{
  XML_Parser p = XML_ParserCreate(NULL);
  if (!p) 
    {
      fprintf(stderr, "Failed initialization of the parser\n");
      exit(EXIT_FAILURE);
    }

  if ((argc <= 1) || (!(strcmp (argv[1], "--help"))) || 
      (!(strcmp(argv[1], "-h"))))
    {
      fprintf(stderr, "update-cluster-parseconfig by Junichi Uekawa 2001\n\n"
	      "update-cluster-parseconfig [element] ...\n"
	      "  parses an XML content, and outputs space-delimited text\n\n"
	      "please read the manpage for details.\n");
      exit (1);      
    }
  

  global_ac = argc;
  global_av = argv;

  XML_SetElementHandler(p, start, end);
  XML_SetCharacterDataHandler(p, characterhandler);
  
  while(1)
    {
      int done;
      int len;
      
      len = fread(Buff, 1, BUFFSIZE, stdin);
      if (ferror(stdin)) 
	{
	  fprintf(stderr, "Read error\n");
	  exit(EXIT_FAILURE);
	}
      done = feof(stdin);
      
      if (! XML_Parse(p, Buff, len, done)) 
	{
	  fprintf(stderr, "Parse error at line %d:\n%s\n",
		  XML_GetCurrentLineNumber(p),
		  XML_ErrorString(XML_GetErrorCode(p)));
	  exit(EXIT_FAILURE);
      }
      
      if (done)
	break;
    }
  exit (EXIT_SUCCESS);
}  

