//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uOStream.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:56:01 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Jul 19 23:02:15 2004
// Update Count     : 100
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uOStream.h>


uOStream &endl( uOStream &os ) {
    uIosWrapper wrapper( os );

    endl( os.ofile );
    return os;
} // endl

uOStream &ends( uOStream &os ) {
    uIosWrapper wrapper( os );

    ends( os.ofile );
    return os;
} // ends

uOStream &flush( uOStream &os ) {
    uIosWrapper wrapper( os );

    flush( os.ofile );
    return os;
} // flush

uOStream &boolalpha( uOStream &os ) {
    uIosWrapper wrapper( os );

    boolalpha( os.ofile );
    return os;
} // boolalpha

uOStream &noboolalpha( uOStream &os ) {
    uIosWrapper wrapper( os );

    noboolalpha( os.ofile );
    return os;
} // noboolalpha

uOStream &showbase( uOStream &os ) {
    uIosWrapper wrapper( os );

    showbase( os.ofile );
    return os;
} // showbase

uOStream &noshowbase( uOStream &os ) {
    uIosWrapper wrapper( os );

    noshowbase( os.ofile );
    return os;
} // noshowbase

uOStream &showpoint( uOStream &os ) {
    uIosWrapper wrapper( os );

    showpoint( os.ofile );
    return os;
} // showpoint

uOStream &noshowpoint( uOStream &os ) {
    uIosWrapper wrapper( os );

    showpoint( os.ofile );
    return os;
} // noshowpoint

uOStream &showpos( uOStream &os ) {
    uIosWrapper wrapper( os );

    showpos( os.ofile );
    return os;
} // showpos

uOStream &noshowpos( uOStream &os ) {
    uIosWrapper wrapper( os );

    showpos( os.ofile );
    return os;
} // noshowpos

uOStream &skipws( uOStream &os ) {
    uIosWrapper wrapper( os );

    skipws( os.ofile );
    return os;
} // skipws

uOStream &noskipws( uOStream &os ) {
    uIosWrapper wrapper( os );

    skipws( os.ofile );
    return os;
} // noskipws

uOStream &uppercase( uOStream &os ) {
    uIosWrapper wrapper( os );

    uppercase( os.ofile );
    return os;
} // uppercase

uOStream &nouppercase( uOStream &os ) {
    uIosWrapper wrapper( os );

    uppercase( os.ofile );
    return os;
} // nouppercase

uOStream &unitbuf( uOStream &os ) {
    uIosWrapper wrapper( os );

    unitbuf( os.ofile );
    return os;
} // unitbuf

uOStream &nounitbuf( uOStream &os ) {
    uIosWrapper wrapper( os );

    unitbuf( os.ofile );
    return os;
} // nounitbuf

uOStream &internal( uOStream &os ) {
    uIosWrapper wrapper( os );

    internal( os.ofile );
    return os;
} // internal

uOStream &left( uOStream &os ) {
    uIosWrapper wrapper( os );

    left( os.ofile );
    return os;
} // left

uOStream &right( uOStream &os ) {
    uIosWrapper wrapper( os );

    right( os.ofile );
    return os;
} // right

uOStream &dec( uOStream &os ) {
    uIosWrapper wrapper( os );

    dec( os.ofile );
    return os;
} // dec

uOStream &hex( uOStream &os ) {
    uIosWrapper wrapper( os );

    hex( os.ofile );
    return os;
} // hex

uOStream &oct( uOStream &os ) {
    uIosWrapper wrapper( os );

    oct( os.ofile );
    return os;
} // oct

uOStream &fixed( uOStream &os ) {
    uIosWrapper wrapper( os );

    fixed( os.ofile );
    return os;
} // fixed

uOStream &scientific( uOStream &os ) {
    uIosWrapper wrapper( os );

    scientific( os.ofile );
    return os;
} // scientific

uOStream &uAcquire( uOStream &os ) {
    os.ownerlock.acquire();
    return os;
} // uAcquire

uOStream &uRelease( uOStream &os ) {
    os.ownerlock.release();
    return os;
} // uRelease


uOStream &operator << ( uOStream &os, char c ) {
    uIosWrapper wrapper( os );

    os.ofile << c;
    return os;
}

uOStream &operator << ( uOStream &os, signed char c ) {
    uIosWrapper wrapper( os );

    os.ofile << c;
    return os;
}

uOStream &operator << ( uOStream &os, unsigned char c ) {
    uIosWrapper wrapper( os );

    os.ofile << c;
    return os;
}

uOStream &operator << ( uOStream &os, const char *s ) {
    uIosWrapper wrapper( os );

    os.ofile << s;
    return os;
}

uOStream &operator << ( uOStream &os, const signed char *s ) {
    uIosWrapper wrapper( os );

    os.ofile << s;
    return os;
}

uOStream &operator << ( uOStream &os, const unsigned char *s ) {
    uIosWrapper wrapper( os );

    os.ofile << s;
    return os;
}


uOStream::uOStream() : ofile( new uFilebuf( std::ios_base::out ) ) {
    iofile = &ofile;
    deletebuf = 1;
} // uOStream::uOStream

uOStream::uOStream( std::streambuf *buf ) : ofile( buf ) {
    iofile = &ofile;
    deletebuf = 0;
} // uOStream::uOStream

uOStream::~uOStream() {
    uIosWrapper wrapper( *this );

    flush();
    if ( deletebuf ) {
	delete rdbuf();
    } // if
} // uOStream::~uOStream

uOStream &uOStream::put( std::streambuf::char_type c ) {
    uIosWrapper wrapper( *this );

    ofile.put( c );
    return *this;
} // uOStream::put

uOStream &uOStream::write( const std::streambuf::char_type *s, std::streamsize n ) {
    uIosWrapper wrapper( *this );

    ofile.write( s, n );
    return *this;
} // uOStream::write

uOStream &uOStream::flush() {
    uIosWrapper wrapper( *this );

    ofile.flush();
    return *this;
} // uOStream::flush

std::streambuf::pos_type uOStream::tellp() {
    uIosWrapper wrapper( *this );

    return tellp();
} // uOStream::tellp

uOStream &uOStream::seekp( std::streambuf::pos_type pos ) {
    uIosWrapper wrapper( *this );

    ofile.seekp( pos );
    return *this;
} // uOStream::seekp

uOStream &uOStream::seekp( std::streambuf::off_type off, std::ios_base::seekdir dir ) {
    uIosWrapper wrapper( *this );

    ofile.seekp( off, dir );
    return *this;
} // uOStream::seekp


uOStream &uOStream::operator << ( uOStream &( *f )( uOStream & ) ) {
    return (*f)( *this );
} // uOStream::operator <<

uOStream &uOStream::operator << ( bool n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<
    
uOStream &uOStream::operator << ( short  n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( unsigned short n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( int n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( unsigned int n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( long n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( unsigned long n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( float  n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( double n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( long double n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( const void *p ) {
    uIosWrapper wrapper( *this );

    ofile << p;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( long long n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<

uOStream &uOStream::operator << ( unsigned long long n ) {
    uIosWrapper wrapper( *this );

    ofile << n;
    return *this;
} // uOStream::operator <<


std::ostream &uOStream::stream() {
    return ofile;
} // uOStream::stream


//######################### uDuration #########################


uOStream &operator<<( uOStream &os, const uDuration op ) {
    uIosWrapper wrapper( os );

    os << op.tv / TIMEGRAN << ".";
    os.width(9);					// nanoseconds
    char oc = os.fill( '0' );
    os << ( op.tv < 0 ? -op.tv : op.tv ) % TIMEGRAN;
    os.fill( oc );
    return os;
} // operator<<


//######################### uTime #########################


uOStream &operator<<( uOStream &os, const uTime op ) {
    uIosWrapper wrapper( os );

    os << op.tv / TIMEGRAN << ".";
    os.width(9);					// nanoseconds
    char oc = os.fill( '0' );
    os << ( op.tv < 0 ? -op.tv : op.tv ) % TIMEGRAN;
    os.fill( oc );
    return os;
} // operator<<


//######################### uOStreamModule #########################


int uOStreamBoot::uCount = 0;
uFilebuf *uOStreamModule::uCoutFilebuf = NULL;
uOStream *uOStreamModule::uCoutStream = NULL;
uFilebuf *uOStreamModule::uCerrFilebuf = NULL;
uOStream *uOStreamModule::uCerrStream = NULL;
uFilebuf *uOStreamModule::uClogFilebuf = NULL;
uOStream *uOStreamModule::uClogStream = NULL;


//######################### uOStream Boot #########################


void uOStreamBoot::startup() {
    uOStreamModule::uCoutFilebuf = new uFilebuf( 1, std::ios_base::out );
    uOStreamModule::uCoutStream  = new uOStream( uOStreamModule::uCoutFilebuf );
    uOStreamModule::uCerrFilebuf = new uFilebuf( 2, std::ios_base::out, 1 ); // 1 byte buffer
    uOStreamModule::uCerrStream  = new uOStream( uOStreamModule::uCerrFilebuf );
    uOStreamModule::uClogFilebuf = new uFilebuf( 2, std::ios_base::out );
    uOStreamModule::uClogStream  = new uOStream( uOStreamModule::uClogFilebuf );
} // uOStreamBoot::startup

void uOStreamBoot::finishup() {
    delete uOStreamModule::uClogStream;
    delete uOStreamModule::uClogFilebuf;
    delete uOStreamModule::uCerrStream;
    delete uOStreamModule::uCerrFilebuf;
    delete uOStreamModule::uCoutStream;
    delete uOStreamModule::uCoutFilebuf;
} // uOStreamBoot::finishup


// Local Variables: //
// compile-command: "gmake install" //
// End: //
