//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uProcessor.h -- 
// 
// Author           : Peter Buhr
// Created On       : Thu May 26 09:36:12 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Aug 11 12:17:31 2004
// Update Count     : 31
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_PROCESSOR_H__
#define __U_PROCESSOR_H__


//######################### uProcessorTask #########################


uTask uProcessorTask {
    friend class uProcessor;				// access: uSetPreemption

    uProcessor &uProc;					// associated processor
    uCondition uResult;


    int uPreemption;					// communication: uSetPreemption
    uCluster *uClus;					// communication: uSetCluster
    uProcessor *uCreateProc;				// communication: uProcCreate
    pid_t uPid;						// communication: uProcWait
    int uRetCode;					// communication: uProcExit

    void main();
    uMutex void uSetPreemption( int ms );
    uMutex void uSetCluster( uCluster &clus );
    uMutex pid_t uProcCreate( uProcessor *np );
    uMutex void uProcWait( pid_t pid );
    uMutex void uProcExit( int retcode ) __attribute__(( noreturn ));

    uProcessorTask( uCluster &uClus, uProcessor &uProc );
    ~uProcessorTask();
  public:
}; // uProcessorTask


#endif // __U_PROCESSOR_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
