//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1999
// 
// TaskConditionBB.cc -- Generic bounded buffer using a task
// 
// Author           : Peter A. Buhr
// Created On       : Mon Nov 22 21:32:23 1999
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 31 21:45:12 2001
// Update Count     : 7
// 

#include <uC++.h>
#include <uIOStream.h>

template<typename ELEMTYPE> uTask BoundedBuffer {
	const int size;										// number of buffer elements
	uCondition NonEmpty, NonFull;
	int front, back;									// position of front and back of queue
	int count;											// number of used elements in the queue
	ELEMTYPE *Elements;
  public:
	BoundedBuffer( const int size = 10 ) : size( size ) {
		front = back = count = 0;
		Elements = new ELEMTYPE[size];
	} // BoundedBuffer::BoundedBuffer

	~BoundedBuffer() {
		delete [] Elements;
	} // BoundedBuffer::~BoundedBuffer

	uNoMutex int query() {
		return count;
	} // BoundedBuffer::query

	void insert( ELEMTYPE elem ) {
		if (count == 20) uWait NonFull;
		Elements[back] = elem;
		back = ( back + 1 ) % size;
		count += 1;
		uSignal NonEmpty;
	} // BoundedBuffer::insert

	ELEMTYPE remove() {
		if (count == 0) uWait NonEmpty;
		ELEMTYPE elem = Elements[front];
		front = ( front + 1 ) % size;
		count -= 1;
		uSignal NonFull;
		return elem;
	} // BoundedBuffer::remove
  protected:
	void main() {
		for ( ;; ) {
			uAccept( ~BoundedBuffer ) {
				break;
			} uOr uAccept( insert, remove ) {
			} // uAccept
		} // for
	} // BoundedBuffer::main
}; // BoundedBuffer

#include "ProdConsDriver.i"

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ TaskConditionBB.cc" //
// End: //
