//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 2003
// 
// EHM8.cc -- 
// 
// Author           : Roy Krischer
// Created On       : Wed Oct  8 22:02:29 2003
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 19 16:41:13 2004
// Update Count     : 38
// 

#include <uC++.h>
#include <uOStream.h>

#define ROUNDS  10000
#define NP 9 

uThrowEvent E1 {};
uInitEvent(E1);
uThrowEvent E2 {};
uInitEvent(E2);


void one() {
    uAbort( "Error 1\n" );
}
void two() {
    uAbort( "Error 2\n" );
}
void three() {
    uCerr << "success" << endl;
    uExit(0);
}

uTask fred {
    int id;
  public:
    fred( int id ) : id(id) {}
    void main() {
	if ( id % 2 ) { 
	    std::set_terminate( one );
	    std::set_unexpected( two );
	} else {
	    std::set_terminate( two );
	    std::set_unexpected( one );
	} // if

	for ( int i = 0; i < ROUNDS; i += 1 ) {
	    uYield();
	    if ( id % 2 ) {
		uAssert( one == std::set_terminate( one ) );
		uAssert( two == std::set_unexpected( two ) );
	    } else {
		uAssert( two == std::set_terminate( two ) );
		uAssert( one == std::set_unexpected( one ) );
	    } // if	    
	} // for
    } // fred::main    
}; // fred


void T1() {
    uCerr << "T1" << endl;
    uThrow E2();
}
void T2() {
    uCerr << "T2" << endl;
    uThrow E2();
}
void T3() {
    uCerr << "T3" << endl;
    uThrow E2();
}

uTask mary {
  public:
    void mem() throw(E2) {
	uThrow E1();
    }
  private:
    void m1() throw(E2) {
	std::set_unexpected( T3 );
	uThrow E1();
    }
    void m2() throw(E2) {
	uThrow E1();
    }
    void main() {
	try {
	    uAccept( mem );
	} catch( uSerial::uRendezvousFailure ) {
	    uCerr << "mary::main 0 caught uRendezvousFailure" << endl;
	}
	try {
	    m1();
	} catch( E2 ) {
	    uCerr << "mary::main 1 caught E2" << endl;
	}
	std::set_unexpected( T1 );
	try {
	    m2();
	} catch( E2 ) {
	    uCerr << "mary::main 2 caught E2" << endl;
	}
    }
};

void uMain::main() {
    uProcessor p[NP];
    fred *f[NP];
    int i;

    for ( i = 0; i < NP; i += 1 ) {
	f[i] = new fred( i );
    } // for
    for ( i = 0; i < NP; i += 1 ) {
	delete f[i];
    } // for

    mary m;
    std::set_unexpected( T2 );
    try {
	m.mem();
    } catch( E2 ) {
	uCerr << "uMain::main caught E2" << endl;
    }
} // uMain::main
