#=========================
#
# AppIndicator for GTK
#  drop-in replacement
#
#    Copyright 2010
#     Nathan Osman
#
#=========================

# We require PyGTK
import gtk

# The definitions needed

# Types
CATEGORY_APPLICATION_STATUS = 0

# Status
STATUS_ACTIVE    = 0
STATUS_ATTENTION = 1

# The main class
class Indicator:
	
	# Constructor
	
	def __init__ (self,unknown,icon,category):
		
		# Store the settings
		self.inactive_icon = "/usr/share/pixmaps/" + icon + ".png"
		self.active_icon   = ""  # Blank until the user calls set_attention_icon
		
		# Create the status icon
		self.icon = gtk.StatusIcon()
		
		# Initialize to the default icon
		self.icon.set_from_file(self.inactive_icon)
		
		# Set the rest of the vars
		self.menu = None    # We have no menu yet
	
	def set_menu(self,menu):
		
		# Save a copy of the menu
		self.menu = menu
		
		# Now attach the icon's signal
		# to the menu so that it becomes displayed
		# whenever the user clicks it
		self.icon.connect("activate", self.show_menu)
	
	def set_status(self,status):
		
		# Status defines whether the active or inactive
		# icon should be displayed.
		if status == STATUS_ACTIVE:
			self.icon.set_from_file(self.inactive_icon)
		else:
			self.icon.set_from_file(self.active_icon)
	
	def set_icon(self,icon):
		
		# Set the new icon
		self.icon.set_from_file("/usr/share/pixmaps/" + icon + ".png")
	
	def set_attention_icon(self,icon):
		
		# Set the icon filename as the attention icon
		self.active_icon = "/usr/share/pixmaps/" + icon + ".png"
	
	def show_menu(self,widget):
		
		# Show the menu
		self.menu.popup(None,None,None,0,0)

