require 'rubyunit'
# Sample of How to use attach_setup

class TestSample01 < RUNIT::TestCase
  # setup is preparing for all test methods.
  def setup
    @x = 1
  end
  
  # setupA is preparing for only testA
  def setupA
    @y = 2
  end

  # setupBC is preparing for test2 and test3
  def setupBC
    @z = 3
  end

  def testA
    assert_equal(3, @x + @y)
    assert_equal(2, @x * @y)
  end
  attach_setup :setupA, :testA

  def testB
    assert_equal(3, @x * @z)
  end

  def testC
    assert_equal(4, @x + @z)
  end
  attach_setup :setupBC, :testB, :testC
end

