=begin
= RUNIT::TestCase class

== SuperClass:
* Object

== Included Modules:
* ((<RUNIT::Assert|URL:./assert.html>))
* ((<RUNIT::Setuppable|URL:./setuppable.html>))
* ((<RUNIT::Teardownable|URL:./teardownable.html>))

== Extended Modules:
* ((<RUNIT::Setuppable|URL:./setuppable.html>))
* ((<RUNIT::Teardownable|URL:./teardownable.html>))

== Class Methods:

: all_suite
      alias of RUNIT::TestCase.test_cases

: suite
      alias of RUNIT::TestCase.test_cases

: test_cases
      Returns TestSuite object consisting of all RUNIT::TestCase objects.

: test_classes
      Returns an array of all sub classes of RUNIT::TestCase.

== Methods:
: self == other
      Returns true if self.type == other.type and 
      self.method_name == other.method_name are true.

: decorated(decorator)
      The test decorator object including TestDecorator calls this method.

: extend_test(module ...)
      alias of extend.

: method_name
      Returns testXXXX method name.

: name
      Returns "TestClass#testXXXX" method name.

: run(result)
      Runs test. The ((|result|)) is the TestResult object which has test result information.

: setup
      You can override this method to do something before test method called.

: teardown
      You can override this method to do something after test method called.

=end

