/*------------------------------------------------------------------------
Module:        replaceit.c
Author:        PLD
Project:       Xamime
State:         alpha
Creation Date: 16/08/2001
Description:   ReplaceIT is to be used on the install script, allowing quick and simple
replacement of various lines which are found in the init scripts, to
start up sendmail.
------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>


#define _RIT_WHOLE_LINE 1

int _replace_option=0;
char _inputfile[1024];

int displayoptions( void )
{
	fprintf(stdout,"\
replaceit - v1.0.0 - PLD Software (C) - http://pldaniels.com/replaceit 2001\n\
Usage: replaceit --input=<filename> [--wholeline] \"<replace>\" \"<with>\" [[\"[+-]<string to be present>\" | \"<-string to be non-present>\"] ...]\n\
\n\
 --input		: Name of file to apply the replacements to\n\
 --wholeline	: Replace the entire line with <with>, rather than partial replacement\n\
 <replace>	: String we're searching for\n\
 <with>		: What we wish to replace <replace> with\n\
 <[+-]string>	: A string which should be also detected on the line\n\
 -<string> 	: A string which we DO NOT want detected in the line\n\
 <}string>	: This string must appear AFTER the section to replace\n\
 <{string>	: This string must appear BEFORE the section to replace\n\
\n\
example: ./replaceit --input=myfile.c \"_MY_DEFINE\" \"_YOUR_DEFINE\" \"-#define\" \"};\"\n\
	\n\
");

	return 1;
}


int replaceline( char *line, int argc, char **argv, int option, FILE *f )
{
	int parity = 0;
	int currentparm = 2;
	int match = 0;
	char *replace = argv[0];
	char *with = argv[1];
	char *p, *q, *cp, *l;
	char *ml;
	int side = 0;

	l = line;
	while ((ml=strstr(l,replace)))
	{
		match = 1;
		for (;currentparm < argc; currentparm++)
		{
			parity = 0;
			side = 0;
			cp = argv[currentparm];

			if (*cp == '-')
			{
				parity = -1;
				cp++;
			}
			else if (*cp == '+')
			{
				cp++;
			}
			else if (*cp == '{')
			{
				cp++;
				side = -1;
			}
			else if (*cp == '}')
			{
				cp++;
				side = 1;
			}

			p = strstr(line,cp);

			if ((side == -1) && (p > ml))
			{
				match=0;
				break;
			}
			else if ((side == 1) && (p < ml))
			{
				match=0;
				break;
			}
			else if ((side != 0) && (!p))
			{
				match=0;
				break;
			}

			if ((parity == -1) && (p))
			{
				match=0;
				break;
			}
			else if ((parity == 0)&&(!p))
			{
				match=0;
				break;
			}
		}//for

		if (match == 1)
		{
			if (option == _RIT_WHOLE_LINE)
			{
				fprintf(f,"%s\n",with);
			}
			else
			    {
				p = strstr(line,replace);
				q = p +strlen(replace);
				*p = '\0';
				fprintf(f,"%s%s%s",line,with,q);
				break; // (out of While)
			}
		}
		l = ++ml;
	}

	if (match == 0) fprintf(f,"%s",line);
	return 1;
}


int readparms( int argc, char **argv )
{
	char *p;
	int i;

	/* determine our arguments */
	for (i = 1; i < argc; i++){

		/* if the first char of the argument is a '-', then we possibly have a flag */
		if ((argv[i][0] == '-')&&(argv[i][1] == '-'))
		{
			p = &(argv[i][2]);

			if (strncmp(p,"input=",6)==0)
			{
				strcpy(_inputfile,(p+6));
			}
			else if (strncmp(p,"wholeline",9)==0)
			{
				_replace_option=_RIT_WHOLE_LINE;
			}
			else
			{
				displayoptions();
				exit(1);
			}
		}
		else break;
	}

	return i;
}



int main( int argc, char **argv )
{
	FILE *f, *tf;
	int startparms;
	char line[1024];
	char tmpname[1024];
	startparms = readparms(argc, argv);

	if (argc < 3)
	{
		displayoptions();
		exit(1);
	}

	if (_inputfile)
	{
		f = fopen(_inputfile,"r");
		if (f)
		{
			sprintf(tmpname,"%s.tmp",_inputfile);
			tf = fopen(tmpname,"w");
			if (tf)
			{
				argc -= startparms;
				argv += startparms;
				while (fgets(line,1024,f))
				{
					replaceline(line, argc, argv, _replace_option, tf);
				}
				fclose(tf); fclose(f);
				rename(tmpname, _inputfile);
			}
			else
			{
				fprintf(stderr,"Error: Cannot open %s (%s)",tmpname,strerror(errno));
			}
		}
		else
		{
			fprintf(stderr,"Error: Cannot open %s (%s)",_inputfile,strerror(errno));
		}
	}
	return 0;
}
