/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.ibm.websphere.ejb;

import xjavadoc.XClass;

import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.env.EnvEjbRefTagsHandler;
import xdoclet.modules.ejb.home.HomeTagsHandler;

/**
 * @author               <a href="mailto:ml at callista.se">Magnus Larsson</a>
 * @created              Dec 26, 2004
 * @xdoclet.taghandler   namespace="WebSphereEjbRef"
 * @version              $Revision 1.1 $
 */
public class WebSphereEjbRefTagsHandler extends EnvEjbRefTagsHandler
{

    /**
     * Returns the global JNDI name for the current EJB ref.<br/>
     * WebSphere can only can have one global JNDI name for an EJB bean even if it expose both a local and a remote
     * interface. In this case we return the remote JNDI-name defined on the bean. <p>
     *
     * <bold>NOTE:</bold> This means that the local JNDI-name will not be used by WebSphere if both a local and a remote
     * interface is exposed on a EJB bean. For portability (with other J2EE servers) reasons you should however always
     * specify both jndi-names in this case.
     *
     * @return                      The JNDI name of current EJB ref.
     * @exception XDocletException
     * @doc.tag                     type="content"
     */
    public String ejbRefJndiName() throws XDocletException
    {
        String ejbRefJndiName = null;

        String jndiNameParameter = currentTag.getAttributeValue("jndi-name");

        // Return the jndi-name on the ejb-ref-tag if any
        if (jndiNameParameter != null) {
            ejbRefJndiName = jndiNameParameter;
        }
        // Return the jndi-name on the ejb-bean depending on the view-type
        else {
            String refed_ejb_name = currentTag.getAttributeValue("ejb-name");

            if (refed_ejb_name == null) {
                throw new XDocletException("No ejb-name attribute found in ejb-ref specified in bean " + getCurrentClass());
            }

            XClass refed_clazz = findEjb(refed_ejb_name);
            String ejb_type = null;

            // If the ejb-bean expose both remote and local itnerfaces we however always return the remote jndi-name since WebSphere only can handle one jndi-name on a ejb-bean.
            if (EjbTagsHandler.isLocalEjb(getCurrentClass()) && EjbTagsHandler.isRemoteEjb(getCurrentClass())) {
                ejb_type = "remote";

            }
            else {
                ejb_type = isLocalEjbRef(currentTag) ? "local" : "remote";
            }

            ejbRefJndiName = HomeTagsHandler.getJndiNameOfTypeFor(ejb_type, refed_clazz);
        }

        return ejbRefJndiName;
    }

}
