/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: mutex.cpp 1110 2003-06-23 09:27:19Z robert $

----------------------------------------------------------------------------*/
#include "mutex.h"

Mutex::Mutex()
{
    mutex = CreateMutex(NULL, false, NULL);
}

Mutex::~Mutex(void)
{
    CloseHandle(mutex);
}

void Mutex::acquire(void)
{
    WaitForSingleObject(mutex, INFINITE);
}

void Mutex::release(void)
{
    ReleaseMutex(mutex);
}
