
require './strscan.so'
require 'amstd/bug'


unless defined? NotImplementedError
  NotImplementedError = NotImplementError
end

def main
  $type = 'C'
  dotest StringScanner
  #dotest StringScanner_C
  #$type = 'Ruby'
  #dotest StringScanner_R

  puts 'ok'
end

def assert( a, b )
  unless a == b then
    bug! "type #{$type}: #{a.inspect} != #{b.inspect}"
  end
end

def dotest( klass )
  begin
    klass.must_C_version
    # assert klass, StringScanner_C
    assert klass, StringScanner
  rescue NotImplementedError
    assert klass, StringScanner_R
  end

  p klass::Version
  p klass::Id

  str = 'str str str str str str HHHHHa G str str cccccc'
  sc = klass.new( str, false )

  sc.inspect

  sc.string.inspect
  assert sc.string.id, str.id

  sc.string = str
  assert sc.string.frozen?, true

  assert sc.pointer, 0

  assert sc.empty?, false
  assert sc.rest?, true

  assert sc.scan( /\A\w+/ ), 'str'
  assert sc.scan( /\A[\t ]+/ ), ' '

  assert sc.skip( /\A\w+/ ), 3
  assert sc.skip( /\A[\t ]+/ ), 1

  assert sc.getch, 's'

  sc.unscan
  assert sc.getch, 's'

  sc.scan( /\w+/ )
  sc.unscan
  assert sc.scan( /\A\w+/ ), 'tr'

  assert sc.check( /\A[\t ]+/ ), ' '
  assert sc.check( /\A[\t ]+/ ), ' '

  sc.scan_until( /H+/ )
  assert sc.getch, 'a'

  i = sc.skip_until( /G/ )
  assert i, 2

  sc.unscan
  s = sc.check_until( /G/ )
  assert s, ' G'

  i = sc.exist?( /G/ )
  assert i, 2

  sc.scan_until( /(str)/ )
  assert sc[0], 'str'
  assert sc[1], 'str'

  sc.clear
  assert sc.empty?, true
  assert sc.rest?, false
end


main
