/* positionCompressor.cc
 */
#include "osl/positionCompressor.h"
#include "osl/position.h"
#include <algorithm>
namespace osl
{
  CArray<signed char, Position::SIZE> PositionCompressor::positionToIndex;

  struct PositionCompressor::Initializer
  {
    Initializer()
    {
      std::fill(positionToIndex.begin(), positionToIndex.end(), -1);

      int cur = 0;
      positionToIndex[0] = cur++;
      for (int x=1; x<=9; ++x)
      {
	for (int y=1; y<=9; ++y)
	{
	  positionToIndex[Position(x,y).index()] = cur++;
	}
      }
      assert(cur == 82);
    }
  };
    
  namespace 
  {
    PositionCompressor::Initializer init;
  } // anonymous namespace
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
