/* hash_map.h
 */
#ifndef HASH_MAP_H
#define HASH_MAP_H

#include "osl/stl/hash.h"
#include "osl/stl/pool_allocator.h"
#if (__GNUC__ >= 4 && __GNUC_MINOR__ >=3)
#  include <tr1/unordered_map>
#elif __GNUC__
#  include <ext/hash_map>
#else
#  include <boost/unordered_map.hpp>
#endif

namespace osl
{
  namespace stl
  {
    template <class T>
    struct hash;
  
#if (__GNUC__ >= 4 && __GNUC_MINOR__ >=3)
    template<class Key, class Value, class HashFun=hash<Key>,
	     class EqualKey=std::equal_to<Key>,
	     class Alloc=pool_allocator<std::pair<const Key, Value> > >
    struct hash_map
      : public std::tr1::unordered_map<Key, Value, HashFun, EqualKey,
				       Alloc>
    {
      typedef std::tr1::unordered_map<Key, Value, HashFun, EqualKey,
				      Alloc> base_t;
      hash_map() {}
      hash_map(size_t s) : base_t(s)
      {
      }
      ~hash_map();
    };
    template<class Key, class Value, class HashFun, class EqualKey, class Alloc>
    hash_map<Key,Value,HashFun,EqualKey,Alloc>::~hash_map()
    {
    }

    template <class T>
    struct hash : public std::tr1::hash<T>
    {
    };
#elif defined __GNUC__
    template<class Key, class Value, class HashFun=osl::stl::hash<Key>,
	     class EqualKey=std::equal_to<Key>,class Alloc=pool_allocator<Value> >
    struct hash_map
      : public __gnu_cxx::hash_map<Key, Value, HashFun, EqualKey, Alloc>
    {
      typedef __gnu_cxx::hash_map<Key, Value, HashFun, EqualKey,
				  Alloc> base_t;
      hash_map() {}
      hash_map(size_t s) : base_t(s)
      {
      }
    };
#else
    template<class Key, class Value, class HashFun=osl::stl::hash<Key>,
	     class EqualKey=std::equal_to<Key>, class Alloc=pool_allocator<std::pair<const Key, Value> > >
    struct hash_map
      : public boost::unordered_map<Key, Value, HashFun, EqualKey, Alloc>
    {
      typedef boost::unordered_map<Key, Value, HashFun, EqualKey,
				   Alloc> base_t;
      hash_map() {}
      hash_map(size_t s) : base_t(s)
      {
      }
      ~hash_map();
    };
    template<class Key, class Value, class HashFun, class EqualKey, class Alloc>
    hash_map<Key,Value,HashFun,EqualKey,Alloc>::~hash_map()
    {
    }

    template <class T>
    struct hash : public boost::hash<T>
    {
    };
#endif
  } // namespace stl
  using stl::hash_map;
} // namespace stl


#endif /* HASH_MAP_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
