/* hashRejections.h
 */
#ifndef _HASHREJECTIONS_H
#define _HASHREJECTIONS_H

#include "osl/state/numEffectState.h"
#include "osl/hash/hashKey.h"
#include <boost/shared_ptr.hpp>
#include <boost/scoped_ptr.hpp>

namespace osl
{
  namespace search
  {
    class HashRejections
    {
      class RootTable;
      class Table;
      boost::shared_ptr<RootTable> root_table;
      boost::scoped_ptr<Table> table;
    public:
      HashRejections();
      HashRejections(const HashRejections&);
      ~HashRejections();
      HashRejections& operator=(const HashRejections&);
      
      void addRejectionRoot(const NumEffectState& parent, const HashKey& key, Move move);
      void clearRejectionRoot(const NumEffectState& parent, const HashKey& key, Move move);
      void addRejection(const NumEffectState& parent, const HashKey& key, Move move);
      void clearRejection(const NumEffectState& parent, const HashKey& key, Move move);

      bool rejectionProbe(const HashKey& cur, const HashKey& parent) const;
    };
  }
}

#endif /* _HASHREJECTIONS_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
