#ifndef _GENERATER_ADD_EFFECT_WITH_EFFECT_TCC
#define _GENERATER_ADD_EFFECT_WITH_EFFECT_TCC

#include "osl/move_generator/addEffectWithEffect.h"
#include "osl/move_generator/open.h"
#include "osl/move_generator/open.tcc"
#include "osl/move_generator/pieceOnBoard.tcc"
#include "osl/checkmate/king8Info.h"

//#define GENERATE_PAWNDROP_CHECKMATE

namespace osl
{
  namespace move_generator
  {
    namespace detail
    {
      /**
       * マスtoに移動可能な駒pを移動する手を生成する．
       * ptypeMaskで指定されたptypeになる場合以外は手を生成しない．
       * @param state - 盤面
       * @param p - 利きを持つコマ
       * @param to - 目的のマス
       * @param toP - 目的のマスに現在ある駒(又は空白)
       * @param action - 手生成のaction(典型的にはstoreかfilterつきstore)
       * @param ptypeMask - 移動後の駒のptypeに対応するbitが1なら手を生成する
       * should promoteは?
       */
      template<osl::Player P,class Action>
      void generateMovePiecePtypeMask(const NumEffectState& state,Piece p,Position to,Piece toP,Action& action,unsigned int ptypeMask)
      {
	assert(p.isOnBoardByOwner<P>());
	assert(toP==state.getPieceAt(to));
	Ptype ptype=p.ptype();
	Position from=p.position();
	if(canPromote(ptype) &&
	   (to.canPromote<P>() || from.canPromote<P>())){
	  Ptype pptype=osl::promote(ptype);
	  if(((1<<pptype)&ptypeMask)!=0)
	    action.unknownMove(from,to,toP,pptype,true,P);
	  if(Move::ignoreUnpromote<P>(ptype,from,to)) return;
	}
	// 
	if(((1<<ptype)&ptypeMask)!=0)
	  action.unknownMove(p.position(),to,toP,ptype,false,P);
      }
      /**
       * あるマスに利きを持つすべての駒の中で，
       * ptypeMaskで指定されたptypeになる場合は移動する手を生成する
       * @param state - 盤面
       * @param to - 目的のマス
       * @param toP - 目的のマスに現在ある駒(又は空白)
       * @param action - 手生成のaction(典型的にはstoreかfilterつきstore)
       * @param ptypeMask - 移動後の駒のptypeに対応するbitが1なら手を生成する
       * pinnedの場合は移動する手が1手もない場合もある．
       */
      template<osl::Player P,class Action>
      void generateMoveToPtypeMaskWithPieceMask(const NumEffectState& state,Position to,Piece toP,Action& action,unsigned int ptypeMask,PieceMask pieceMask)
      {
	if(pieceMask.test(KingTraits<P>::index)){
	  const Player altP=PlayerTraits<P>::opponent;
	  if(!state.hasEffectBy<altP>(to)){
	    action.unknownMove(state.getKingPosition<P>(),to,toP,KING,false,P);
	  }
	  pieceMask.reset(KingTraits<P>::index);
	}
	while (pieceMask.any()){
	  const int num=pieceMask.takeOneBit();
	  Piece p=state.getPieceOf(num);
	  if(state.pinOrOpen(P).test(num)){
	    Direction d=state.pinnedDir<P>(p);
	    Direction d1=Board_Table.template getShort8Unsafe<P>(p.position(),to);
	    if(primDir(d)!=primDirUnsafe(d1)) continue;
	  }
	  generateMovePiecePtypeMask<P,Action>(state,p,to,toP,action,ptypeMask);
	}
      }
      template<osl::Player P,class Action>
      void generateMoveToPtypeMask(const NumEffectState& state,Position to,Piece toP,Action& action,unsigned int ptypeMask)
      {
	PieceMask pieceMask=state.getOnBoardMask(P)&state.getEffect(to);
	const Player altP=PlayerTraits<P>::opponent;
	pieceMask.reset(KingTraits<P>::index); // 玉は除く
	pieceMask &= ~state.pinOrOpen(altP); // open atackからのものを除く
	generateMoveToPtypeMaskWithPieceMask<P,Action>(state,to,toP,action,ptypeMask,pieceMask);
      }
#ifndef GENERATE_PAWNDROP_CHECKMATE
      /**
       * 敵玉の前に歩を置いた場合に遮った利きで敵玉にlibertyが生まれるかどうか?
       */
      template<osl::Player P>
      bool blockingU(const NumEffectState& state,Position pos)
      {
	const osl::Player altP=PlayerTraits<P>::opponent;
	NumBitmapEffect effect=state.getEffect(pos);
	mask_t mask=(effect.getMask(1)& NumBitmapEffect::longEffectMask());
	mask&=state.getOnBoardMask(P).getMask(1)<<8; // ROOK, BISHOPの利きのみのはず
	while(mask.any()){
	  int num=mask.takeOneBit()+NumBitmapEffect::longToNumOffset;
	  Position from=state.getPieceOf(num).position();
	  if( (P==BLACK ? from.y()>=pos.y() : pos.y()>=from.y()) ){
	    Position shadowPos=pos+Board_Table.getShortOffset(Offset32(pos,from));
	    assert((P==BLACK ? shadowPos.y()<=pos.y() : pos.y()<=shadowPos.y()) );
	    Piece p=state.getPieceAt(shadowPos);
	    if(p.canMoveOn<altP>() && !state.hasMultipleEffectBy(P,shadowPos)){
	      return true;
	    }
	  }
	}
	return false;
      }
#endif
      /**
       * int DirType : 0  - U
       *               1  - LRD
       *               2  - UL,UR,DL,DR
       * dirOffset = DirectionPlayerTraits<Dir,P>::offset()
       */
      template<osl::Player P,int DirType,class Action>
      void generateDir(const NumEffectState& state,Position target,Action& action,bool& hasPawnCheckmate,Offset dirOffset,Direction Dir,Direction primDir,int ptypeMaskNotKing)
      {
	const Player altP=PlayerTraits<P>::opponent;
	Position pos=target-dirOffset;
	if(!pos.isOnBoard()) return;
	Piece p=state.getPieceAt(pos);
	if(p.isOnBoardByOwner<P>()){
	  if(DirType==0 && state.hasEffectLong<LANCE>(P,pos)){
	    PieceOnBoard<Action>::template generate<P,true>(state,p,action,1<<primDir);
	  }
	  return;
	}
	if((state.Iking8Info(altP)&(1ull<<(40+Dir)))!=0){
	  // - posに利きがある
	  // TODO safe moveではない
	  generateMoveToPtypeMask<P,Action>(state,pos,p,action,
					    ptypeMaskNotKing);
	}
	if(DirType !=0) return;
	if(p.isEmpty()){
	  Position pos1=state.kingMobilityOfPlayer(altP,Dir);
	  mask_t lance_mask=state.selectLong<LANCE>(pos1,P);
	  if(lance_mask.any()){
	    Piece p1=state.getPieceAt(pos1);
	    if(p1.isOnBoardByOwner<P>()){
	      PieceOnBoard<Action>::template generate<P,true>(state,p1,action,1<<primDir);
	      // 
	      if(state.hasEffectByPiece(p1,pos)){
		PieceOnBoard<Action>::template generatePiece<P>(state,p1,pos,Piece::EMPTY(),action);
	      }
	    }
	    else if(p1.isOnBoardByOwner<altP>()){
	      assert(!lance_mask.hasMultipleBit());
	      int num=lance_mask.bsf()+PtypeFuns<LANCE>::indexNum*32;
	      Piece p2=state.getPieceOf(num);
	      action.unknownMove(p2.position(),pos1,p1,LANCE,false,P);
	    }
	  }
	  // - PAWN, LANCEはここで調べる?
	  //  + ただしPAWNはつみは禁止
	  if(! state.isPawnMaskSet<P>(target.x()) &&
	     state.hasPieceOnStand<PAWN>(P)){
	    // 利きをさえぎるパターンの検証
#ifndef GENERATE_PAWNDROP_CHECKMATE
	    if(((state.Iking8Info(altP)&(0xff00ull|(1ull<<(U+24))))^(1ull<<(U+24)))!=0 || blockingU<P>(state,pos))
	      action.dropMove(pos,PAWN,P);
	    else
	      hasPawnCheckmate=true;
#else
	    action.dropMove(pos,PAWN,P);
#endif
	  }
	  if(state.hasPieceOnStand<LANCE>(P)){
	    action.dropMove(pos,LANCE,P);
	    for(pos-=DirectionPlayerTraits<U,P>::offset();
		pos!=pos1;pos-=DirectionPlayerTraits<U,P>::offset()){
	      action.dropMove(pos,LANCE,P);
	    }
	  }
	}
      }

      template<osl::Player P,int DirType,class Action,Direction Dir>
      void generateDir(const NumEffectState& state,Position target,Action& action,bool& hasPawnCheckmate)
      {
	generateDir<P,DirType,Action>(state,target,action,hasPawnCheckmate,
				      DirectionPlayerTraits<Dir,P>::offset(),Dir,DirectionTraits<Dir>::primDir,DirectionTraits<Dir>::ptypeMaskNotKing);
      }
      /**
       * int DirType : 0  - U
       *               1  - LRD
       *               2  - UL,UR,DL,DR
       * dirOffset = DirectionPlayerTraits<Dir,P>::offset()
       */
      template<osl::Player P,int DirType,class Action>
      void generateDirNotKing(const NumEffectState& state,Position target,Action& action,CArray<unsigned char,8>& pieceMobility, int& spaces, PieceMask const& notPieceMask,Offset dirOffset,Direction Dir,Direction primDir,int ptypeMask,Direction dirByBlack
	)
      {
	const Player altP=PlayerTraits<P>::opponent;
	Position pos=target-dirOffset;
	if(!pos.isOnBoard()){
	  pieceMobility[dirByBlack]=pos.uintValue();
	  return;
	}
	Piece p=state.getPieceAt(pos);
	if(p.canMoveOn<P>()){
	  // - posに利きがある
	  const PieceMask pieceMask=state.getOnBoardMask(P)&state.getEffect(pos)&notPieceMask & ~state.getEffect(target);
	  if(pieceMask.any())
	    detail:: template generateMoveToPtypeMaskWithPieceMask<P,Action>(state,pos,p,action,
									     ptypeMask,pieceMask);
	}
	Position nextPosition=pos;
	if(p.isEmpty()){
	  spaces|=(1u<<Dir);
	  if(DirType==0 && ! state.isPawnMaskSet<P>(target.x()) &&
	     state.hasPieceOnStand<PAWN>(P))
	    action.dropMove(pos,PAWN,P);
	  do{
	    pos-=dirOffset;
	    p=state.getPieceAt(pos);
	  } while(p.isEmpty());
	}
	if(p.isOnBoardByOwner<P>() && state.hasEffectByPiece(p,target)){
	  for(;;){
	    Piece p1=state.longEffectOfDirection(P,p,inverse(Dir));
	    if(!p1.isOnBoardByOwner<P>()){
	      break;
	    }
	    p=p1;
	  } 
	  pos=p.position()-dirOffset;
	  while((p=state.getPieceAt(pos)).isEmpty())
	    pos-=dirOffset;
	}
	else if (p.isOnBoardByOwner<altP>() && state.hasEffectByPiece(p,target)){
	  // shadowは1つだけ見る
	  Piece p1=state.longEffectOfDirection(altP,p,Dir);
	  if(p1.isOnBoardByOwner<P>()){
	    if(pos!=nextPosition){
	      Position from=p1.position();
	      PieceOnBoard<Action>::template generatePiece<P>(state,p1,pos,p,action);
	    }
	    pos=p1.position();
	    p=p1;
	  }
	  else{
	    pos=p.position()-dirOffset;
	    while((p=state.getPieceAt(pos)).isEmpty())
	      pos-=dirOffset;
	  }
	}
      	pieceMobility[dirByBlack]=pos.uintValue();
	if(p.isOnBoardByOwner<P>()){
	  Piece p1=state.longEffectOfDirection(P,p,inverse(Dir));
	  if(p1.isOnBoardByOwner<P>()){
	    Open<Action>::template generate<P>(state,p,action,target,primDir);
	  }
	}
	else if(p.isOnBoardByOwner<altP>() && pos!=nextPosition){
	  if(DirType==0){
	    mask_t lance_mask=state.selectLong<LANCE>(pos,P);
	    if(lance_mask.any()){
	      assert(!lance_mask.hasMultipleBit());
	      int num=lance_mask.bsf()+PtypeFuns<LANCE>::indexNum*32;
	      if(!state.pinOrOpen(P).test(num)){
		Piece p2=state.getPieceOf(num);
		action.unknownMove(p2.position(),pos,p,LANCE,false,P);
	      }
	    }
	  }
	  if(DirType <= 1){
	    mask_t rook_mask=state.effectBit<ROOK>(P,pos);
	    while(rook_mask.any()){
	      int num=rook_mask.takeOneBit()+PtypeFuns<ROOK>::indexNum*32;
	      Piece p2=state.getPieceOf(num);
	      if(p2.position()==target) continue;
	      PieceOnBoard<Action>::template generatePiece<P>(state,p2,pos,p,action);
	    }
	  }
	  if(DirType == 2){
	    mask_t bishop_mask=state.effectBit<BISHOP>(P,pos);
	    // 利きをチェックする必要あり
	    while(bishop_mask.any()){
	      int num=bishop_mask.takeOneBit()+PtypeFuns<BISHOP>::indexNum*32;
	      Piece p2=state.getPieceOf(num);
	      if(p2.position()==target) continue;
	      PieceOnBoard<Action>::template generatePiece<P>(state,p2,pos,p,action);
	    }
	  }
	}

	// - PAWN, LANCEはここで調べる?
	//  + ただしPAWNはつみは禁止
	if(DirType == 0){
	  if(state.hasPieceOnStand<LANCE>(P)){
	    for(pos+=DirectionPlayerTraits<U,P>::offset();
		pos!=target;pos+=DirectionPlayerTraits<U,P>::offset()){
	      if(state.getPieceAt(pos).isEmpty())
		action.dropMove(pos,LANCE,P);
	    }
	  }
	}
      }

      template<osl::Player P,int DirType,class Action,Direction Dir>
      void generateDirNotKing(const NumEffectState& state,Position target,Action& action,CArray<unsigned char,8>& pieceMobility, int& spaces, PieceMask const& notPieceMask)
      {
	generateDirNotKing<P,DirType,Action>(state,target,action,pieceMobility,spaces,notPieceMask,
					     DirectionPlayerTraits<Dir,P>::offset(),Dir,DirectionTraits<Dir>::primDir,DirectionTraits<Dir>::ptypeMask,DirectionPlayerTraits<Dir,P>::directionByBlack);
	
      }
      template<osl::Player P,osl::Direction Dir,class Action,bool hasKnight>
      void generateKnightDir(const NumEffectState& state,Position target,Action& action)
      {
	Position pos=target-DirectionPlayerTraits<Dir,P>::offset();
	if(!pos.isOnBoard()) return;
	Piece p=state.getPieceAt(pos);
	if(!p.canMoveOn<P>()) return;
	mask_t mask=state.effectBit<KNIGHT>(P, pos);
	mask &= ~state.promotedPieces().getMask<KNIGHT>();
	// pinnedなknightは動けない
	mask &= ~state.pinOrOpen(P).getMask(PtypeFuns<KNIGHT>::indexNum);
	while(mask.any()){
	  const int num = mask.takeOneBit()+PtypeFuns<KNIGHT>::indexNum*32;
	  Piece p1=state.getPieceOf(num);
	  action.unknownMove(p1.position(),pos,p,KNIGHT,false,P);
	}
	if(hasKnight && p.isEmpty()){
	  action.dropMove(pos,KNIGHT,P);
	}
      }
      template<osl::Player P,class Action>
      void generateKnightAll(const NumEffectState& state,Position target,Action& action)
      {
	if(state.hasPieceOnStand<KNIGHT>(P)){
	  detail::generateKnightDir<P,UUL,Action,true>(state,target,action);
	  detail::generateKnightDir<P,UUR,Action,true>(state,target,action);
	}
	else{
	  detail::generateKnightDir<P,UUL,Action,false>(state,target,action);
	  detail::generateKnightDir<P,UUR,Action,false>(state,target,action);
	}
      }
      template <osl::Player P,class Action>
      void generateDrop(Position target,Action& action,int spaceMask,osl::Ptype T,int dirMask,Offset offset)
      {
	if((spaceMask&dirMask)!=0){
	  Position pos=target-offset;
	  action.dropMove(pos,T,P);
	}
      }
      template <osl::Player P,class Action,Direction Dir>
      void generateDropDir(Position target,Action& action,int spaceMask,osl::Ptype T)
      {
	generateDrop<P,Action>(target,action,spaceMask,T,(1<<Dir),DirectionPlayerTraits<Dir,P>::offset());
      }
      template<Player P,class Action,bool mustCareSilver>
      void generateOpenOrCapture(const NumEffectState& state,Position target,Piece p,int num,Action& action)
      {
	// TODO: pin, captureを作る
	Direction d=Board_Table.template getShort8<P>(p.position(),target);
	Position mid=state.getMobility((P==BLACK ? d : inverse(d)),num);
	assert(mid.isOnBoard());
	const Player altP=PlayerTraits<P>::opponent;
	Position mid1=state.kingMobilityOfPlayer(altP,d);
	if(mid==mid1){
	  Piece p1=state.getPieceAt(mid);
	  assert(p1.isPiece());
	  Position target_next=target-Board_Table.getShort8OffsetUnsafe(p.position(),target);
	  if((P==BLACK ? p1.pieceIsBlack() : !p1.pieceIsBlack())){
	    // open attack
	    PieceOnBoard<Action>::template generate<P,true>(state,p1,action,(1<<primDir(d)));
	    // p1がtarget_nextに利きを持つ
	    if(state.hasEffectByPiece(p1,target_next)){
	      // silverが斜め下に利きを持つ場合は「成らず」しか生成しない
	      if(mustCareSilver && p1.ptype()==SILVER && 
		 (P==BLACK ? target.y()>mid.y() : target.y()<mid.y())){
		// pinの場合は動ける可能性はない 
		if(!state.pinOrOpen(P).test(p1.number())){
		  action.unknownMove(mid,target_next,Piece::EMPTY(),SILVER,false,P);
		}
	      }
	      else
		PieceOnBoard<Action>::template generatePiece<P>(state,p1,target_next,Piece::EMPTY(),action);
	    }
	  }
	  else{
	    // 隣の場合はすでに作っている
	    if(mid==target_next)
	      return;
	    PieceOnBoard<Action>::template generatePiece<P>(state,p,mid,p1,action);
	  }
	}
      }

      template<osl::Player P,class Action>
      void generateRookLongMove(const NumEffectState& state,Position target,Action& action)
      {
	const Player altP=PlayerTraits<P>::opponent;
	for(int num=PtypeTraits<ROOK>::indexMin;num<PtypeTraits<ROOK>::indexLimit;num++){
	  // pinの場合はすでに作っている
	  if(state.pinOrOpen(altP).test(num)) continue;
	  Piece p=state.getPieceOf(num);
	  if(!p.isOnBoardByOwner<P>()) continue;
	  if(target.isULRD(p.position())){
	    generateOpenOrCapture<P,Action,false>(state,target,p,num,action);
	    continue;
	  }
	  int target_x=target.x();
	  int target_y=target.y();
	  int rook_x=p.position().x();
	  int rook_y=p.position().y();
	  if(p.isPromoted()){
	    if((unsigned int)(target_x-rook_x+1)>2u){ // abs(target_x-rook_x)>1
	      if((unsigned int)(target_y-rook_y+1)>2u){ // abs(target_y-rook_y)>1
		{
		  Position pos(rook_x,target_y);
		  Piece p1=state.getPieceAt(pos);
		  if(state.getEffect(pos).test(num) &&
		     p1.canMoveOn<P>() &&
		     state.kingMobilityAbs(altP,R).uintValue() >= pos.uintValue() &&
		     pos.uintValue() >= state.kingMobilityAbs(altP,L).uintValue() &&
		     (!state.pinOrOpen(P).test(num) ||
		      p.position().isUD(state.getKingPosition<P>()))
		    ){
		    action.unknownMove(p.position(),pos,p1,PROOK,false,P);
		  }
		}
		{
		  Position pos(target_x,rook_y);
		  Piece p1=state.getPieceAt(pos);
		  if(state.getEffect(pos).test(num) &&
		     p1.canMoveOn<P>() &&
		     state.kingMobilityAbs(altP,U).uintValue() >= pos.uintValue() &&
		     pos.uintValue() >= state.kingMobilityAbs(altP,D).uintValue() &&
		     (!state.pinOrOpen(P).test(num) ||
		      p.position().isLR(state.getKingPosition<P>()))
		    ){
		    action.unknownMove(p.position(),pos,p1,PROOK,false,P);
		  }
		}
	      }
	      else{ // (abs(target_x-rook_x)>1 && abs(target_y-rook_y)==1
		int min_x=state.kingMobilityAbs(altP,L).x();
		int max_x=state.kingMobilityAbs(altP,R).x();
		if(target_x>rook_x) max_x=target_x-2;
		else min_x=target_x+2;
		min_x=std::max(min_x,rook_x-1);
		max_x=std::min(max_x,rook_x+1);
		for(int x=min_x;x<=max_x;x++){
		  Position pos=Position::makeNoCheck(x,target_y);
		  Piece p1=state.getPieceAt(pos);
		  if(p1.canMoveOn<P>())
		    PieceOnBoard<Action>::template generatePiecePtype<P,PROOK>(state,p,pos,p1,action);
		}
	      }
	    }
	    else if((unsigned int)(target_y-rook_y+1)>2u){ // abs(target_y-rook_y)>1, abs(target_x-rook_x)==1
	      int min_y=state.kingMobilityAbs(altP,D).y();
	      int max_y=state.kingMobilityAbs(altP,U).y();
	      if(target_y>rook_y) max_y=target_y-2;
	      else min_y=target_y+2;
	      min_y=std::max(min_y,rook_y-1);
	      max_y=std::min(max_y,rook_y+1);
	      for(int y=min_y;y<=max_y;y++){
		Position pos=Position::makeNoCheck(target_x,y);
		Piece p1=state.getPieceAt(pos);
		if(p1.canMoveOn<P>())
		  PieceOnBoard<Action>::template generatePiecePtype<P,PROOK>(state,p,pos,p1,action);
	      }
	    }
	  }
	  else{ // ROOK
	    // vertical move
	    if((unsigned int)(target_x-rook_x+1)>2u){ // abs(target_x-rook_x)>1
	      Position pos(rook_x,target_y);
	      Piece p1=state.getPieceAt(pos);
	      if(state.getEffect(pos).test(num) &&
		 p1.canMoveOn<P>() &&
		 state.kingMobilityAbs(altP,R).uintValue() >= pos.uintValue() &&
		 pos.uintValue() >= state.kingMobilityAbs(altP,L).uintValue() &&
		 (!state.pinOrOpen(P).test(num) ||
		  p.position().isUD(state.getKingPosition<P>()))
		){
		if(Position::canPromoteY<P>(rook_y) || Position::canPromoteY<P>(target_y)){
		  action.unknownMove(p.position(),pos,p1,PROOK,true,P);
		}
		else action.unknownMove(p.position(),pos,p1,ROOK,false,P);
	      }
	    }
	    // horizontal move
	    if((unsigned int)(target_y-rook_y+1)>2u){ // abs(target_y-rook_y)>1
	      Position pos(target_x,rook_y);
	      Piece p1=state.getPieceAt(pos);
	      if(state.getEffect(pos).test(num) &&
		 p1.canMoveOn<P>() &&
		 state.kingMobilityAbs(altP,U).uintValue() >= pos.uintValue() &&
		 pos.uintValue() >= state.kingMobilityAbs(altP,D).uintValue() &&
		 (!state.pinOrOpen(P).test(num) ||
		  p.position().isLR(state.getKingPosition<P>()))
		){
		if(Position::canPromoteY<P>(rook_y)){
		  action.unknownMove(p.position(),pos,p1,PROOK,true,P);
		}
		else
		  action.unknownMove(p.position(),pos,p1,ROOK,false,P);
	      }
	    }
	  }
	}
      }
      template<osl::Player P,class Action>
      void generateRookLongMoveNotKing(const NumEffectState& state,Position target,Action& action,CArray<unsigned char,8> const& pieceMobility)
      {
	for(int num=PtypeTraits<ROOK>::indexMin;num<PtypeTraits<ROOK>::indexLimit;num++){
	  Piece p=state.getPieceOf(num);
	  if(!p.isOnBoardByOwner<P>()) continue;
	  if(target.isULRD(p.position())){
	    continue;
	  }
	  int target_x=target.x();
	  int target_y=target.y();
	  int rook_x=p.position().x();
	  int rook_y=p.position().y();
	  if(p.isPromoted()){
	    if((unsigned int)(target_x-rook_x+1)>2u){ // abs(target_x-rook_x)>1
	      if((unsigned int)(target_y-rook_y+1)>2u){ // abs(target_y-rook_y)>1
		{
		  Position pos(rook_x,target_y);
		  Piece p1=state.getPieceAt(pos);
		  if(p1.canMoveOn<P>() &&
		     pieceMobility[R] > pos.uintValue() &&
		     pos.uintValue() > pieceMobility[L] &&
		     state.getEffect(pos).test(num)
		    ){
		    action.unknownMove(p.position(),pos,p1,PROOK,false,P);
		  }
		}
		{
		  Position pos(target_x,rook_y);
		  Piece p1=state.getPieceAt(pos);
		  if(p1.canMoveOn<P>() &&
		     pieceMobility[U] > pos.uintValue() &&
		     pos.uintValue() > pieceMobility[D] &&
		     state.getEffect(pos).test(num)){
		    action.unknownMove(p.position(),pos,p1,PROOK,false,P);
		  }
		}
	      }
	      else{ // (abs(target_x-rook_x)>1 && abs(target_y-rook_y)==1
		int min_x=Position::makeDirect(pieceMobility[L]).x()+1;
		int max_x=Position::makeDirect(pieceMobility[R]).x()-1;
		if(target_x>rook_x) max_x=target_x-2;
		else min_x=target_x+2;
		min_x=std::max(min_x,rook_x-1);
		max_x=std::min(max_x,rook_x+1);
		for(int x=min_x;x<=max_x;x++){
		  Position pos=Position::makeNoCheck(x,target_y);
		  Piece p1=state.getPieceAt(pos);
		  if(p1.canMoveOn<P>())
		    action.unknownMove(p.position(),pos,p1,PROOK,false,P);
		}
	      }
	    }
	    else if((unsigned int)(target_y-rook_y+1)>2u){ // abs(target_y-rook_y)>1, abs(target_x-rook_x)==1
	      int min_y=Position::makeDirect(pieceMobility[D]).y()+1;
	      int max_y=Position::makeDirect(pieceMobility[U]).y()-1;
	      if(target_y>rook_y) max_y=target_y-2;
	      else min_y=target_y+2;
	      min_y=std::max(min_y,rook_y-1);
	      max_y=std::min(max_y,rook_y+1);
	      for(int y=min_y;y<=max_y;y++){
		Position pos=Position::makeNoCheck(target_x,y);
		Piece p1=state.getPieceAt(pos);
		if(p1.canMoveOn<P>())
		  action.unknownMove(p.position(),pos,p1,PROOK,false,P);
	      }
	    }
	  }
	  else{ // ROOK
	    // vertical move
	    if((unsigned int)(target_x-rook_x+1)>2u){ // abs(target_x-rook_x)>1
	      Position pos(rook_x,target_y);
	      Piece p1=state.getPieceAt(pos);
	      if(p1.canMoveOn<P>() &&
		 pieceMobility[R] > pos.uintValue() &&
		 pos.uintValue() > pieceMobility[L] &&
		 state.getEffect(pos).test(num)
		){
		if(Position::canPromoteY<P>(rook_y) || Position::canPromoteY<P>(target_y)){
		  action.unknownMove(p.position(),pos,p1,PROOK,true,P);
		}
		else
		  action.unknownMove(p.position(),pos,p1,ROOK,false,P);
	      }
	    }
	    // horizontal move
	    if((unsigned int)(target_y-rook_y+1)>2u){ // abs(target_y-rook_y)>1
	      Position pos(target_x,rook_y);
	      Piece p1=state.getPieceAt(pos);
	      if(p1.template canMoveOn<P>() &&
		 pieceMobility[U] > pos.uintValue() &&
		 pos.uintValue() > pieceMobility[D] &&
		 state.getEffect(pos).test(num)
		){
		if(Position::canPromoteY<P>(rook_y)){
		  action.unknownMove(p.position(),pos,p1,PROOK,true,P);
		}
		else
		  action.unknownMove(p.position(),pos,p1,ROOK,false,P);
	      }
	    }
	  }
	}
      }
      template<Player P,Ptype T,class Action>
      void generateBishopLongMove(const NumEffectState& state,Position target,Action& action,Piece p,int num)
      {
	const Player altP=PlayerTraits<P>::opponent;
	int target_x=target.x();
	int target_y=target.y();
	int target_xPy=target_x+target_y;
	int target_xMy=target_x-target_y;
	int bishop_x=p.position().x();
	int bishop_y=p.position().y();
	int bishop_xPy=bishop_x+bishop_y;
	int bishop_xMy=bishop_x-bishop_y;
	if(((target_xPy^bishop_xPy)&1)!=0){
	  if(T==BISHOP) return;
	  // 市松模様のparityの違う場合も，隣ならOK?
	  if((unsigned int)(target_xPy-bishop_xPy+1)<=2u){ // abs(target_xPy-bishop_xPy)==1
	    Position ul=state.kingMobilityAbs(altP,UL);
	    Position dr=state.kingMobilityAbs(altP,DR);
	    int min_xMy=ul.x()-ul.y();
	    int max_xMy=dr.x()-dr.y();
	    if(target_xMy>bishop_xMy) max_xMy=target_xMy-4;
	    else min_xMy=target_xMy+4;
	    min_xMy=std::max(min_xMy,bishop_xMy-1);
	    max_xMy=std::min(max_xMy,bishop_xMy+1);
	    for(int xMy=min_xMy;xMy<=max_xMy;xMy+=2){
	      int pos_x=(target_xPy+xMy)>>1;
	      int pos_y=(target_xPy-xMy)>>1;
	      Position pos=Position::makeNoCheck(pos_x,pos_y);
	      Piece p1=state.getPieceAt(pos);
	      if(p1.canMoveOn<P>())
		PieceOnBoard<Action>::template generatePiecePtype<P,T>(state,p,pos,p1,action);
	    }
	  }
	  else if((unsigned int)(target_xMy-bishop_xMy+1)<=2u){ // abs(target_xMy-bishop_xMy)==1
	    Position dl=state.kingMobilityAbs(altP,DL);
	    Position ur=state.kingMobilityAbs(altP,UR);
	    int min_xPy=dl.x()+dl.y();
	    int max_xPy=ur.x()+ur.y();
	    if(target_xPy>bishop_xPy) max_xPy=target_xPy-4;
	    else min_xPy=target_xPy+4;
	    min_xPy=std::max(min_xPy,bishop_xPy-1);
	    max_xPy=std::min(max_xPy,bishop_xPy+1);
	    for(int xPy=min_xPy;xPy<=max_xPy;xPy+=2){
	      int pos_x=(xPy+target_xMy)>>1;
	      int pos_y=(xPy-target_xMy)>>1;
	      Position pos=Position::makeNoCheck(pos_x,pos_y);
	      Piece p1=state.getPieceAt(pos);
	      if(p1.canMoveOn<P>())
		PieceOnBoard<Action>::template generatePiecePtype<P,T>(state,p,pos,p1,action);
	    }
	  }
	  return;
	}
	//  / 方向(dx==dy)から王手をかける
	if((unsigned int)(target_xPy-bishop_xPy+2)>4u){ // abs(target_xPy-bishop_xPy)>2
	  int pos_x=(bishop_xPy+target_xMy)>>1;
	  int pos_y=(bishop_xPy-target_xMy)>>1;
	  Position pos=Position::makeNoCheck(pos_x,pos_y);
	  if(pos.isOnBoard()){
	    Piece p1=state.getPieceAt(pos);
	    if(state.getEffect(pos).test(num) &&
	       p1.canMoveOn<P>() &&
	       state.kingMobilityAbs(altP,UR).uintValue() >= pos.uintValue() &&
	       pos.uintValue() >= state.kingMobilityAbs(altP,DL).uintValue()
	      ){
	      PieceOnBoard<Action>::template generatePiecePtype<P,T>(state,p,pos,p1,action);
	    }
	  }
	}
	else if(target_xPy==bishop_xPy){
	  generateOpenOrCapture<P,Action,true>(state,target,p,num,action);
	  return;
	}
	//  \ 方向(dx== -dy)から王手をかける
	if((unsigned int)(target_xMy-bishop_xMy+2)>4u){ // abs(target_xMy-bishop_xMy)>2
	  int pos_x=(target_xPy+bishop_xMy)>>1;
	  int pos_y=(target_xPy-bishop_xMy)>>1;
	  Position pos=Position::makeNoCheck(pos_x,pos_y);
	  if(pos.isOnBoard()){
	    Piece p1=state.getPieceAt(pos);
	    if(state.getEffect(pos).test(num) &&
	       p1.canMoveOn<P>() &&
	       state.kingMobilityAbs(altP,DR).uintValue() >= pos.uintValue() &&
	       pos.uintValue() >= state.kingMobilityAbs(altP,UL).uintValue()
	      ){
	      PieceOnBoard<Action>::template generatePiecePtype<P,T>(state,p,pos,p1,action);
	    }
	  }
	}
	else if(target_xMy==bishop_xMy){
	  generateOpenOrCapture<P,Action,true>(state,target,p,num,action);
	  return;
	}

      }
      template<osl::Player P,Ptype T,class Action>
      void generateBishopLongMoveNotKing(const NumEffectState& state,Position target,Action& action,CArray<unsigned char,8> const& pieceMobility,Piece p,int num)
      {
	int target_x=target.x();
	int target_y=target.y();
	int target_xPy=target_x+target_y;
	int target_xMy=target_x-target_y;
	int bishop_x=p.position().x();
	int bishop_y=p.position().y();
	int bishop_xPy=bishop_x+bishop_y;
	int bishop_xMy=bishop_x-bishop_y;
	if(((target_xPy^bishop_xPy)&1)!=0){
	  if(T!=PBISHOP) return;
	  // 市松模様のparityの違う場合も，隣ならOK?
	  if((unsigned int)(target_xPy-bishop_xPy+1)<=2u){ // abs(target_xPy-bishop_xPy)==1
	    Position ul=Position::makeDirect(pieceMobility[UL]);
	    Position dr=Position::makeDirect(pieceMobility[DR]);
	    int min_xMy=ul.x()-ul.y()+2;
	    int max_xMy=dr.x()-dr.y()-2;
	    if(target_xMy>bishop_xMy) max_xMy=target_xMy-4;
	    else min_xMy=target_xMy+4;
	    min_xMy=std::max(min_xMy,bishop_xMy-1);
	    max_xMy=std::min(max_xMy,bishop_xMy+1);
	    for(int xMy=min_xMy;xMy<=max_xMy;xMy+=2){
	      int pos_x=(target_xPy+xMy)>>1;
	      int pos_y=(target_xPy-xMy)>>1;
	      Position pos=Position::makeNoCheck(pos_x,pos_y);
	      Piece p1=state.getPieceAt(pos);
	      if(p1.canMoveOn<P>())
		PieceOnBoard<Action>::template generatePiecePtype<P,T>(state,p,pos,p1,action);
	    }
	    return;
	  }
	  else if((unsigned int)(target_xMy-bishop_xMy+1)<=2u){ // abs(target_xMy-bishop_xMy)==1
	    Position dl=Position::makeDirect(pieceMobility[DL]);
	    Position ur=Position::makeDirect(pieceMobility[UR]);
	    int min_xPy=dl.x()+dl.y()+2;
	    int max_xPy=ur.x()+ur.y()-2;
	    if(target_xPy>bishop_xPy) max_xPy=target_xPy-4;
	    else min_xPy=target_xPy+4;
	    min_xPy=std::max(min_xPy,bishop_xPy-1);
	    max_xPy=std::min(max_xPy,bishop_xPy+1);
	    for(int xPy=min_xPy;xPy<=max_xPy;xPy+=2){
	      int pos_x=(xPy+target_xMy)>>1;
	      int pos_y=(xPy-target_xMy)>>1;
	      Position pos=Position::makeNoCheck(pos_x,pos_y);
	      Piece p1=state.getPieceAt(pos);
	      if(p1.canMoveOn<P>())
		PieceOnBoard<Action>::template generatePiecePtype<P,T>(state,p,pos,p1,action);
	    }
	  }
	  return;
	}
	//  / 方向(dx==dy)から王手をかける
	if((unsigned int)(target_xPy-bishop_xPy+2)>4u){ // abs(target_xPy-bishop_xPy)>2
	  int pos_x=(bishop_xPy+target_xMy)>>1;
	  int pos_y=(bishop_xPy-target_xMy)>>1;
	  Position pos=Position::makeNoCheck(pos_x,pos_y);
	  if(pos.isOnBoard()){
	    if(pieceMobility[UR] > pos.uintValue() &&
	       pos.uintValue() > pieceMobility[DL] &&
	       state.getEffect(pos).test(num)){
	      Piece p1=state.getPieceAt(pos);
	      if(p1.canMoveOn<P>())
		PieceOnBoard<Action>::template generatePiecePtype<P,T>(state,p,pos,p1,action);
	    }
	  }
	}
	//  \ 方向(dx== -dy)から王手をかける
	if((unsigned int)(target_xMy-bishop_xMy+2)>4u){ // abs(target_xMy-bishop_xMy)>2
	  int pos_x=(target_xPy+bishop_xMy)>>1;
	  int pos_y=(target_xPy-bishop_xMy)>>1;
	  Position pos=Position::makeNoCheck(pos_x,pos_y);
	  if(pos.isOnBoard()){
	    if(pieceMobility[DR] > pos.uintValue() &&
	       pos.uintValue() > pieceMobility[UL] &&
	       state.getEffect(pos).test(num)
	      ){
	      Piece p1=state.getPieceAt(pos);
	      if(p1.canMoveOn<P>())
		PieceOnBoard<Action>::template generatePiecePtype<P,T>(state,p,pos,p1,action);
	    }
	  }
	}
      }
    
      template<Player P,class Action>
      void generateDropGold(const NumEffectState& state,Position target,Action& action,int spaces)
      {
	if(!state.hasPieceOnStand<GOLD>(P)) return;
	unsigned int gold_mask=spaces&((1<<U)|(1<<UR)|(1<<UL)|(1<<L)|(1<<R)|(1<<D));
	if(gold_mask==0) return;
	generateDropDir<P,Action,U>(target,action,gold_mask,GOLD);
	generateDropDir<P,Action,UL>(target,action,gold_mask,GOLD);
	generateDropDir<P,Action,UR>(target,action,gold_mask,GOLD);
	generateDropDir<P,Action,L>(target,action,gold_mask,GOLD);
	generateDropDir<P,Action,R>(target,action,gold_mask,GOLD);
	generateDropDir<P,Action,D>(target,action,gold_mask,GOLD);
      }
      template<Player P,class Action>
      void generateDropSilver(const NumEffectState& state,Position target,Action& action,int spaces)
      {
	if(!state.hasPieceOnStand<SILVER>(P)) return;
	unsigned int silver_mask=spaces&((1<<U)|(1<<UR)|(1<<UL)|(1<<DL)|(1<<DR));
	if(silver_mask ==0) return;

	generateDropDir<P,Action,DL>(target,action,silver_mask,SILVER);
	generateDropDir<P,Action,DR>(target,action,silver_mask,SILVER);
	generateDropDir<P,Action,U>(target,action,silver_mask,SILVER);
	generateDropDir<P,Action,UL>(target,action,silver_mask,SILVER);
	generateDropDir<P,Action,UR>(target,action,silver_mask,SILVER);
      }
      /**
       * allEmpty - shadow attackを生成する場合は，posがemptyでないこともある．
       */
      template<Player P,class Action,bool allEmpty>
      void generateDropBishop(const NumEffectState& state,Position target,Action& action,Position ul,Position dr,Position ur,Position dl)
      {
	for(Position pos=dl+DirectionPlayerTraits<DL,P>::offset();
	    pos!=target;pos+=DirectionPlayerTraits<DL,P>::offset())
	  if(allEmpty || state.getPieceAt(pos).isEmpty())
	    action.dropMove(pos,BISHOP,P);
	for(Position pos=dr-DirectionPlayerTraits<UL,P>::offset();
	    pos!=target;pos-=DirectionPlayerTraits<UL,P>::offset())
	  if(allEmpty || state.getPieceAt(pos).isEmpty())
	    action.dropMove(pos,BISHOP,P);
	for(Position pos=ul+DirectionPlayerTraits<UL,P>::offset();
	    pos!=target;pos+=DirectionPlayerTraits<UL,P>::offset())
	  if(allEmpty || state.getPieceAt(pos).isEmpty())
	    action.dropMove(pos,BISHOP,P);
	for(Position pos=ur-DirectionPlayerTraits<DL,P>::offset();
	    pos!=target;pos-=DirectionPlayerTraits<DL,P>::offset())
	  if(allEmpty || state.getPieceAt(pos).isEmpty())
	    action.dropMove(pos,BISHOP,P);
      }

      template<Player P,class Action,bool allEmpty>
      void generateDropRook(const NumEffectState& state,Position target,Action& action,Position l,Position r,Position d,Position u)
      {
	for(Position pos=u-DirectionPlayerTraits<D,P>::offset();
	    pos!=target;pos-=DirectionPlayerTraits<D,P>::offset())
	  if(allEmpty || state.getPieceAt(pos).isEmpty())
	    action.dropMove(pos,ROOK,P);
	for(Position pos=l+DirectionPlayerTraits<L,P>::offset();
	    pos!=target;pos+=DirectionPlayerTraits<L,P>::offset())
	  if(allEmpty || state.getPieceAt(pos).isEmpty())
	    action.dropMove(pos,ROOK,P);
	for(Position pos=r-DirectionPlayerTraits<L,P>::offset();
	    pos!=target;pos-=DirectionPlayerTraits<L,P>::offset())
	  if(allEmpty || state.getPieceAt(pos).isEmpty())
	    action.dropMove(pos,ROOK,P);
	for(Position pos=d+DirectionPlayerTraits<D,P>::offset();
	    pos!=target;pos+=DirectionPlayerTraits<D,P>::offset())
	  if(allEmpty || state.getPieceAt(pos).isEmpty())
	    action.dropMove(pos,ROOK,P);
      }
      template<osl::Player P,class Action>
      void generateKing(const NumEffectState& state,Position target,Action& action,bool &hasPawnCheckmate)
      {
	
	const Player altP=PlayerTraits<P>::opponent;
	assert(target==state.getKingPosition(altP));
	generateDir<P,0,Action,U>(state,target,action,hasPawnCheckmate);
	generateKnightAll<P,Action>(state,target,action);
	generateDir<P,2,Action,UL>(state,target,action,hasPawnCheckmate);
	generateDir<P,2,Action,UR>(state,target,action,hasPawnCheckmate);
	generateDir<P,1,Action,L>(state,target,action,hasPawnCheckmate);
	generateDir<P,1,Action,R>(state,target,action,hasPawnCheckmate);
	generateDir<P,1,Action,D>(state,target,action,hasPawnCheckmate);
	generateDir<P,2,Action,DL>(state,target,action,hasPawnCheckmate);
	generateDir<P,2,Action,DR>(state,target,action,hasPawnCheckmate);
	detail::generateRookLongMove<P,Action>(state,target,action);
	for(int num=PtypeTraits<BISHOP>::indexMin;num<PtypeTraits<BISHOP>::indexLimit;num++){
	  // pinの場合はすでに作っている
	  if(state.pinOrOpen(altP).test(num)) continue;
	  Piece p=state.getPieceOf(num);
	  if(!p.isOnBoardByOwner<P>()) continue;
	  if(p.isPromoted())
	    generateBishopLongMove<P,PBISHOP,Action>(state,target,action,p,num);
	  else
	    generateBishopLongMove<P,BISHOP,Action>(state,target,action,p,num);
	}
	int spaces=King8Info(state.Iking8Info(altP)).spaces();
	generateDropGold<P,Action>(state,target,action,spaces);
	generateDropSilver<P,Action>(state,target,action,spaces);
	// bishop
	if(state.hasPieceOnStand<BISHOP>(P)){
	  generateDropBishop<P,Action,true>(state,target,action,
					    state.kingMobilityOfPlayer(altP,UL),
					    state.kingMobilityOfPlayer(altP,DR),
					    state.kingMobilityOfPlayer(altP,UR),
					    state.kingMobilityOfPlayer(altP,DL));
	}
	if(state.hasPieceOnStand<ROOK>(P)){
	  Position l,r,d,u;
	  l=state.kingMobilityOfPlayer(altP,L);
	  r=state.kingMobilityOfPlayer(altP,R);
	  d=state.kingMobilityOfPlayer(altP,D);
	  u=state.kingMobilityOfPlayer(altP,U);
	  generateDropRook<P,Action,true>(state,target,action,l,r,d,u);
	}
      }
      template<osl::Player P,class Action>
      void generateNotKing(const NumEffectState& state,Position target,Action& action)
      {
	int spaces=0;
	CArray<unsigned char,8> pieceMobility;
	PieceMask notPieceMask;
	notPieceMask.setAll();
	int num=state.getPieceAt(target).number();
	if(num != EMPTY_NUM){
	  notPieceMask.reset(num);
	}
	generateDirNotKing<P,0,Action,U>(state,target,action,pieceMobility,spaces,notPieceMask);
	generateKnightAll<P,Action>(state,target,action);
	generateDirNotKing<P,2,Action,UL>(state,target,action,pieceMobility,spaces,notPieceMask);
	generateDirNotKing<P,2,Action,UR>(state,target,action,pieceMobility,spaces,notPieceMask);
	generateDirNotKing<P,1,Action,L>(state,target,action,pieceMobility,spaces,notPieceMask);
	generateDirNotKing<P,1,Action,R>(state,target,action,pieceMobility,spaces,notPieceMask);
	generateDirNotKing<P,1,Action,D>(state,target,action,pieceMobility,spaces,notPieceMask);
	generateDirNotKing<P,2,Action,DL>(state,target,action,pieceMobility,spaces,notPieceMask);
	generateDirNotKing<P,2,Action,DR>(state,target,action,pieceMobility,spaces,notPieceMask);
	// rookが移動する手
	generateRookLongMoveNotKing<P,Action>(state,target,action,pieceMobility);
	// bishopが移動する手
	for(int num=PtypeTraits<BISHOP>::indexMin;num<PtypeTraits<BISHOP>::indexLimit;num++){
	  Piece p=state.getPieceOf(num);
	  if(!p.isOnBoardByOwner<P>()) continue;
	  if(p.isPromoted())
	    generateBishopLongMoveNotKing<P,PBISHOP,Action>(state,target,action,pieceMobility,p,num);
	  else
	    generateBishopLongMoveNotKing<P,BISHOP,Action>(state,target,action,pieceMobility,p,num);
	}
	generateDropGold<P,Action>(state,target,action,spaces);
	generateDropSilver<P,Action>(state,target,action,spaces);
	if(state.hasPieceOnStand<BISHOP>(P)){
	  Position ul,dr,dl,ur;
	  ul=Position::makeDirect(pieceMobility[P==BLACK ? UL : DR]);
	  dr=Position::makeDirect(pieceMobility[P==BLACK ? DR : UL]);
	  ur=Position::makeDirect(pieceMobility[P==BLACK ? UR : DL]);
	  dl=Position::makeDirect(pieceMobility[P==BLACK ? DL : UR]);
	  generateDropBishop<P,Action,false>(state,target,action,ul,dr,ur,dl);
	}
	if(state.hasPieceOnStand<ROOK>(P)){
	  Position l,r,d,u;
	  l=Position::makeDirect(pieceMobility[P==BLACK ? L : R]);
	  r=Position::makeDirect(pieceMobility[P==BLACK ? R : L]);
	  d=Position::makeDirect(pieceMobility[P==BLACK ? D : U]);
	  u=Position::makeDirect(pieceMobility[P==BLACK ? U : D]);
	  generateDropRook<P,Action,false>(state,target,action,l,r,d,u);
	}
      }
    } // namespace detail
    template <class Action>
    template <osl::Player P,bool isAttackToKing>
    void osl::move_generator::AddEffectWithEffect<Action>::
    generate(const NumEffectState& state,Position target,Action& action,bool &hasPawnCheckmate)
    {
      if(!isAttackToKing){
	detail::template generateNotKing<P,Action>(state,target,action);
      }
      else{
	detail::template generateKing<P,Action>(state,target,action,hasPawnCheckmate);
      }
    }
    template<bool isAttackToKing>
    void osl::move_generator::GenerateAddEffectWithEffect::
    generate(Player player, const NumEffectState& state, Position target, 
	     move_action::Store& store)
    {
      using namespace osl::move_action;
      bool dummy;
      if(player==BLACK){
	AddEffectWithEffect<Store>::generate<BLACK,isAttackToKing>(state,target,store,dummy);
      }
      else{
	AddEffectWithEffect<Store>::generate<WHITE,isAttackToKing>(state,target,store,dummy);
      }
    }

  } // namespace move_generator
} // namespace osl
#endif /* _GENERATER_ADD_EFFECT_WITH_EFFECT_TCC */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
