#ifndef _PROMOTE_MOVE_ACTION_H
#define _PROMOTE_MOVE_ACTION_H
#include "osl/move_action/concept.h"
namespace osl
{
  namespace effect_action
  {
    /**
     * SimplePromote と違って， unknownMove を呼ぶ
     */
    template<class Action>
    class Promote
    {
      BOOST_CLASS_REQUIRE(Action,osl::move_action,Concept);
    private:
      const NumEffectState& state;
      Action & ac;
    public:
      Promote(const NumEffectState& s, Action& a) 
	: state(s), ac(a)
      {
      }
      template<Player P,Ptype Type>
      void doActionPtype(Piece p1,Position to){
	Position from=p1.position();
	if(p1.isPromoted())
	  ac.unknownMove(from,to,state.getPieceAt(to),promote(Type),false,P);
	else if(to.canPromote<P>() || from.canPromote<P>())
	  ac.unknownMove(from,to,state.getPieceAt(to),promote(Type),true,P);
      }
      template<Player P>
      void doAction(Piece p1,Position to){
	Position from=p1.position();
	Ptype ptype=p1.ptype();
	if(p1.isPromoted())
	  ac.unknownMove(from,to,state.getPieceAt(to),ptype,false,P);
	else if(to.canPromote<P>() || from.canPromote<P>())
	  ac.unknownMove(from,to,state.getPieceAt(to),promote(ptype),true,P);
      }
      bool done() const{ return false;}
    };
  } // namespace effect_action
} // namespace osl
#endif
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
