/* pieceMask32.h
 */
#ifndef PIECEMASK32_H
#define PIECEMASK32_H

#include "osl/misc/mask.h"
#include "osl/misc/carray.h"

namespace osl
{
  namespace container
  {
  class PieceMask32
  {
  protected:
    CArray<misc::Mask32,2> mask;
  public:
    static int numToIndex(int num)  { return num>>5; }
    static int numToOffset(int num) { return num&31; }

    PieceMask32()
    {
      resetAll();
    }
    PieceMask32(const misc::Mask32& m1,const misc::Mask32& m2)
    {
      mask[0]=m1; mask[1]=m2;
    }
  protected:
    misc::Mask32& mutableMask(int index) { return mask[index]; }
  public:
    const misc::Mask32& getMask(int index) const
    {
      return mask[index];
    }
    PieceMask32& operator^=(const PieceMask32& o)
    {
      mask[0] ^= o.mask[0];
      mask[1] ^= o.mask[1];
      return *this;
    }
    PieceMask32& operator&=(const PieceMask32& o)
    {
      mask[0] &= o.mask[0];
      mask[1] &= o.mask[1];
      return *this;
    }
    PieceMask32& operator|=(const PieceMask32& o)
    {
      mask[0] |= o.mask[0];
      mask[1] |= o.mask[1];
      return *this;
    }
    PieceMask32& operator-=(const PieceMask32& o)
    {
      mask[0] -= o.mask[0];
      mask[1] -= o.mask[1];
      return *this;
    }
    PieceMask32& operator+=(const PieceMask32& o)
    {
      mask[0] += o.mask[0];
      mask[1] += o.mask[1];
      return *this;
    }
    void resetAll()
    {
      mask[0]=mask[1]=misc::Mask32::makeDirect(0u);
    }
    void setAll()
    {
      mask[0]=misc::Mask32::makeDirect(0xffffffffu); 
      mask[1]=misc::Mask32::makeDirect(0xffu);
    }
    bool none() const
    {  
      return (mask[0]|mask[1]).none();
    }
    bool hasMultipleBit() const
    {
      if (none()) 
	return false;
      if (! mask[0].any()) 
	return mask[1].hasMultipleBit();
      if (! mask[1].any())
	return mask[0].hasMultipleBit();
      return true;
    }
    /**
     * bit の数を2まで数える
     * @return 0,1,2 (2の場合は2以上)
     */
    int countBit2() const 
    {
      if (none()) 
	return 0;
      if (! mask[0].any()) 
	return mask[1].countBit2();
      if (! mask[1].any()) 
	return mask[0].countBit2();
      return 2;
    }
    int countBit() const 
    {
      return mask[0].countBit() + mask[1].countBit();
    }
    int takeOneBit()
    {
      assert(!none());
      if(! mask[0].none())
	return mask[0].takeOneBit();
      return mask[1].takeOneBit()+32;
    }
  };
} // namespace container
  using container::PieceMask32;
} // namespace osl


#endif /* PIECEMASK32_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
