#--
# =============================================================================
# Copyright (c) 2004,2005 Jamis Buck (jamis_buck@byu.edu)
# All rights reserved.
#
# This source file is distributed as part of the Net::SSH Secure Shell Client
# library for Ruby. This file (and the library as a whole) may be used only as
# allowed by either the BSD license, or the Ruby license (or, by association
# with the Ruby license, the GPL). See the "doc" subdirectory of the Net::SSH
# distribution for the texts of these licenses.
# -----------------------------------------------------------------------------
# net-ssh website : http://net-ssh.rubyforge.org
# project website: http://rubyforge.org/projects/net-ssh
# =============================================================================
#++

require 'openssl'

module Net
  module SSH
    module Transport
      module OSSL

        module HMAC

          # The base class of all OpenSSL-based HMAC algorithm wrappers.
          class Abstract

            # The number of bytes in the digest generated by this algorithm.
            attr_reader :mac_length

            # The digest algorithm to use when computing the HMAC digest.
            attr_reader :digest_class

            # The number of bytes that this algorithm expects the key to
            # contain.
            attr_reader :key_length

            # The key to use for this instance.
            attr_accessor :key

            # Return a new HMAC algorithm just like the current one, but using
            # the given key.
            def new( key )
              mac = dup
              mac.key = key[ 0, key_length ]
              return mac
            end

            # Compute the HMAC digest for the given data string.
            def digest( data )
              OpenSSL::HMAC.digest( digest_class.new, key, data )[0,mac_length]
            end

          end

        end

      end
    end
  end
end
