/* language-model.c generated by valac 0.24.0.131-42e78, the Vala compiler
 * generated from language-model.vala, do not modify */

/*
 * Copyright (C) 2012-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <gee.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>


#define KKC_TYPE_LANGUAGE_MODEL_ENTRY (kkc_language_model_entry_get_type ())
typedef struct _KkcLanguageModelEntry KkcLanguageModelEntry;
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_METADATA_FILE (kkc_metadata_file_get_type ())
#define KKC_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFile))
#define KKC_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))
#define KKC_IS_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_METADATA_FILE))
#define KKC_IS_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_METADATA_FILE))
#define KKC_METADATA_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))

typedef struct _KkcMetadataFile KkcMetadataFile;
typedef struct _KkcMetadataFileClass KkcMetadataFileClass;
typedef struct _KkcMetadataFilePrivate KkcMetadataFilePrivate;

#define KKC_TYPE_LANGUAGE_MODEL_METADATA (kkc_language_model_metadata_get_type ())
#define KKC_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadata))
#define KKC_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))
#define KKC_IS_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_IS_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_LANGUAGE_MODEL_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))

typedef struct _KkcLanguageModelMetadata KkcLanguageModelMetadata;
typedef struct _KkcLanguageModelMetadataClass KkcLanguageModelMetadataClass;
typedef struct _KkcLanguageModelMetadataPrivate KkcLanguageModelMetadataPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;

#define KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL (kkc_text_bigram_language_model_get_type ())
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModel))
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModelClass))
#define KKC_IS_TEXT_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL))
#define KKC_IS_TEXT_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL))
#define KKC_TEXT_BIGRAM_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL, KkcTextBigramLanguageModelClass))

typedef struct _KkcTextBigramLanguageModel KkcTextBigramLanguageModel;
typedef struct _KkcTextBigramLanguageModelClass KkcTextBigramLanguageModelClass;

#define KKC_TYPE_TEXT_TRIGRAM_LANGUAGE_MODEL (kkc_text_trigram_language_model_get_type ())
#define KKC_TEXT_TRIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_TEXT_TRIGRAM_LANGUAGE_MODEL, KkcTextTrigramLanguageModel))
#define KKC_TEXT_TRIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_TEXT_TRIGRAM_LANGUAGE_MODEL, KkcTextTrigramLanguageModelClass))
#define KKC_IS_TEXT_TRIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_TEXT_TRIGRAM_LANGUAGE_MODEL))
#define KKC_IS_TEXT_TRIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_TEXT_TRIGRAM_LANGUAGE_MODEL))
#define KKC_TEXT_TRIGRAM_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_TEXT_TRIGRAM_LANGUAGE_MODEL, KkcTextTrigramLanguageModelClass))

typedef struct _KkcTextTrigramLanguageModel KkcTextTrigramLanguageModel;
typedef struct _KkcTextTrigramLanguageModelClass KkcTextTrigramLanguageModelClass;

#define KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL (kkc_sorted_bigram_language_model_get_type ())
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModel))
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModelClass))
#define KKC_IS_SORTED_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL))
#define KKC_IS_SORTED_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL))
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModelClass))

typedef struct _KkcSortedBigramLanguageModel KkcSortedBigramLanguageModel;
typedef struct _KkcSortedBigramLanguageModelClass KkcSortedBigramLanguageModelClass;

#define KKC_TYPE_SORTED_TRIGRAM_LANGUAGE_MODEL (kkc_sorted_trigram_language_model_get_type ())
#define KKC_SORTED_TRIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SORTED_TRIGRAM_LANGUAGE_MODEL, KkcSortedTrigramLanguageModel))
#define KKC_SORTED_TRIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SORTED_TRIGRAM_LANGUAGE_MODEL, KkcSortedTrigramLanguageModelClass))
#define KKC_IS_SORTED_TRIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SORTED_TRIGRAM_LANGUAGE_MODEL))
#define KKC_IS_SORTED_TRIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SORTED_TRIGRAM_LANGUAGE_MODEL))
#define KKC_SORTED_TRIGRAM_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SORTED_TRIGRAM_LANGUAGE_MODEL, KkcSortedTrigramLanguageModelClass))

typedef struct _KkcSortedTrigramLanguageModel KkcSortedTrigramLanguageModel;
typedef struct _KkcSortedTrigramLanguageModelClass KkcSortedTrigramLanguageModelClass;
typedef struct _KkcLanguageModelPrivate KkcLanguageModelPrivate;

#define KKC_TYPE_UNIGRAM_LANGUAGE_MODEL (kkc_unigram_language_model_get_type ())
#define KKC_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel))
#define KKC_IS_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL))
#define KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModelIface))

typedef struct _KkcUnigramLanguageModel KkcUnigramLanguageModel;
typedef struct _KkcUnigramLanguageModelIface KkcUnigramLanguageModelIface;

#define KKC_TYPE_BIGRAM_LANGUAGE_MODEL (kkc_bigram_language_model_get_type ())
#define KKC_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModel))
#define KKC_IS_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL))
#define KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModelIface))

typedef struct _KkcBigramLanguageModel KkcBigramLanguageModel;
typedef struct _KkcBigramLanguageModelIface KkcBigramLanguageModelIface;

#define KKC_TYPE_TRIGRAM_LANGUAGE_MODEL (kkc_trigram_language_model_get_type ())
#define KKC_TRIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_TRIGRAM_LANGUAGE_MODEL, KkcTrigramLanguageModel))
#define KKC_IS_TRIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_TRIGRAM_LANGUAGE_MODEL))
#define KKC_TRIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_TRIGRAM_LANGUAGE_MODEL, KkcTrigramLanguageModelIface))

typedef struct _KkcTrigramLanguageModel KkcTrigramLanguageModel;
typedef struct _KkcTrigramLanguageModelIface KkcTrigramLanguageModelIface;

typedef enum  {
	KKC_LANGUAGE_MODEL_ERROR_NOT_FOUND
} KkcLanguageModelError;
#define KKC_LANGUAGE_MODEL_ERROR kkc_language_model_error_quark ()
struct _KkcLanguageModelEntry {
	gchar* input;
	gchar* output;
	guint id;
};

struct _KkcMetadataFile {
	GObject parent_instance;
	KkcMetadataFilePrivate * priv;
};

struct _KkcMetadataFileClass {
	GObjectClass parent_class;
	gboolean (*parse) (KkcMetadataFile* self, JsonObject* object, GError** error);
};

struct _KkcLanguageModelMetadata {
	KkcMetadataFile parent_instance;
	KkcLanguageModelMetadataPrivate * priv;
};

struct _KkcLanguageModelMetadataClass {
	KkcMetadataFileClass parent_class;
};

struct _KkcLanguageModelMetadataPrivate {
	GType _model_type;
};

typedef enum  {
	KKC_METADATA_FORMAT_ERROR_MISSING_FIELD,
	KKC_METADATA_FORMAT_ERROR_INVALID_FIELD
} KkcMetadataFormatError;
#define KKC_METADATA_FORMAT_ERROR kkc_metadata_format_error_quark ()
struct _KkcLanguageModel {
	GObject parent_instance;
	KkcLanguageModelPrivate * priv;
};

struct _KkcLanguageModelClass {
	GObjectClass parent_class;
	GeeCollection* (*unigram_entries) (KkcLanguageModel* self, const gchar* input);
	GeeCollection* (*entries) (KkcLanguageModel* self, const gchar* input);
	KkcLanguageModelEntry* (*get) (KkcLanguageModel* self, const gchar* input, const gchar* output);
	gboolean (*parse) (KkcLanguageModel* self, GError** error);
	void (*get_bos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
	void (*get_eos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
};

struct _KkcLanguageModelPrivate {
	KkcLanguageModelMetadata* _metadata;
};

struct _KkcUnigramLanguageModelIface {
	GTypeInterface parent_iface;
	gdouble (*unigram_cost) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
	gdouble (*unigram_backoff) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
};

struct _KkcBigramLanguageModelIface {
	GTypeInterface parent_iface;
	gboolean (*has_bigram) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_cost) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_backoff) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
};

struct _KkcTrigramLanguageModelIface {
	GTypeInterface parent_iface;
	gboolean (*has_trigram) (KkcTrigramLanguageModel* self, KkcLanguageModelEntry* ppentry, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*trigram_cost) (KkcTrigramLanguageModel* self, KkcLanguageModelEntry* ppentry, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
};


static gpointer kkc_language_model_metadata_parent_class = NULL;
static GeeMap* kkc_language_model_metadata_model_types;
static GeeMap* kkc_language_model_metadata_model_types = NULL;
static gpointer kkc_language_model_parent_class = NULL;
static GInitableIface* kkc_language_model_g_initable_parent_iface = NULL;

GQuark kkc_language_model_error_quark (void);
GType kkc_language_model_entry_get_type (void) G_GNUC_CONST;
KkcLanguageModelEntry* kkc_language_model_entry_dup (const KkcLanguageModelEntry* self);
void kkc_language_model_entry_free (KkcLanguageModelEntry* self);
void kkc_language_model_entry_copy (const KkcLanguageModelEntry* self, KkcLanguageModelEntry* dest);
void kkc_language_model_entry_destroy (KkcLanguageModelEntry* self);
GType kkc_metadata_file_get_type (void) G_GNUC_CONST;
GType kkc_language_model_metadata_get_type (void) G_GNUC_CONST;
#define KKC_LANGUAGE_MODEL_METADATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataPrivate))
enum  {
	KKC_LANGUAGE_MODEL_METADATA_DUMMY_PROPERTY,
	KKC_LANGUAGE_MODEL_METADATA_MODEL_TYPE
};
KkcLanguageModelMetadata* kkc_language_model_metadata_new (const gchar* name, const gchar* filename, GError** error);
KkcLanguageModelMetadata* kkc_language_model_metadata_construct (GType object_type, const gchar* name, const gchar* filename, GError** error);
KkcMetadataFile* kkc_metadata_file_construct (GType object_type, const gchar* name, const gchar* filename, GError** error);
static gboolean kkc_language_model_metadata_real_parse (KkcMetadataFile* base, JsonObject* object, GError** error);
GQuark kkc_metadata_format_error_quark (void);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
void kkc_language_model_metadata_set_model_type (KkcLanguageModelMetadata* self, GType value);
KkcLanguageModelMetadata* kkc_language_model_metadata_find (const gchar* name);
gchar** kkc_utils_build_data_path (const gchar* subdir, int* result_length1);
GType kkc_language_model_get_type (void) G_GNUC_CONST;
KkcLanguageModel* kkc_language_model_metadata_create_language_model (KkcLanguageModelMetadata* self, GError** error);
GType kkc_language_model_metadata_get_model_type (KkcLanguageModelMetadata* self);
static GType* _g_type_dup (GType* self);
GType kkc_text_bigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_text_trigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_sorted_bigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_sorted_trigram_language_model_get_type (void) G_GNUC_CONST;
static void kkc_language_model_metadata_finalize (GObject* obj);
static void _vala_kkc_language_model_metadata_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_language_model_metadata_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define KKC_LANGUAGE_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelPrivate))
enum  {
	KKC_LANGUAGE_MODEL_DUMMY_PROPERTY,
	KKC_LANGUAGE_MODEL_METADATA,
	KKC_LANGUAGE_MODEL_BOS,
	KKC_LANGUAGE_MODEL_EOS
};
GeeCollection* kkc_language_model_unigram_entries (KkcLanguageModel* self, const gchar* input);
static GeeCollection* kkc_language_model_real_unigram_entries (KkcLanguageModel* self, const gchar* input);
GeeCollection* kkc_language_model_entries (KkcLanguageModel* self, const gchar* input);
static GeeCollection* kkc_language_model_real_entries (KkcLanguageModel* self, const gchar* input);
KkcLanguageModelEntry* kkc_language_model_get (KkcLanguageModel* self, const gchar* input, const gchar* output);
static KkcLanguageModelEntry* kkc_language_model_real_get (KkcLanguageModel* self, const gchar* input, const gchar* output);
KkcLanguageModel* kkc_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error);
gboolean kkc_language_model_parse (KkcLanguageModel* self, GError** error);
static gboolean kkc_language_model_real_parse (KkcLanguageModel* self, GError** error);
static gboolean kkc_language_model_real_init (GInitable* base, GCancellable* cancellable, GError** error);
KkcLanguageModel* kkc_language_model_load (const gchar* name, GError** error);
KkcLanguageModelMetadata* kkc_language_model_get_metadata (KkcLanguageModel* self);
void kkc_language_model_set_metadata (KkcLanguageModel* self, KkcLanguageModelMetadata* value);
void kkc_language_model_get_bos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
void kkc_language_model_get_eos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
static void kkc_language_model_finalize (GObject* obj);
static void _vala_kkc_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_language_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType kkc_unigram_language_model_get_type (void) G_GNUC_CONST;
gdouble kkc_unigram_language_model_unigram_cost (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
gdouble kkc_unigram_language_model_unigram_backoff (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
GType kkc_bigram_language_model_get_type (void) G_GNUC_CONST;
gboolean kkc_bigram_language_model_has_bigram (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
gdouble kkc_bigram_language_model_bigram_cost (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
gdouble kkc_bigram_language_model_bigram_backoff (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
gdouble kkc_bigram_language_model_bigram_backoff_cost (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
GType kkc_trigram_language_model_get_type (void) G_GNUC_CONST;
gboolean kkc_trigram_language_model_has_trigram (KkcTrigramLanguageModel* self, KkcLanguageModelEntry* ppentry, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
gdouble kkc_trigram_language_model_trigram_cost (KkcTrigramLanguageModel* self, KkcLanguageModelEntry* ppentry, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
gdouble kkc_trigram_language_model_trigram_backoff_cost (KkcTrigramLanguageModel* self, KkcLanguageModelEntry* ppentry, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark kkc_language_model_error_quark (void) {
	return g_quark_from_static_string ("kkc_language_model_error-quark");
}


void kkc_language_model_entry_copy (const KkcLanguageModelEntry* self, KkcLanguageModelEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	_tmp0_ = (*self).input;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).input);
	(*dest).input = _tmp1_;
	_tmp2_ = (*self).output;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).output);
	(*dest).output = _tmp3_;
	_tmp4_ = (*self).id;
	(*dest).id = _tmp4_;
}


void kkc_language_model_entry_destroy (KkcLanguageModelEntry* self) {
	_g_free0 ((*self).input);
	_g_free0 ((*self).output);
}


KkcLanguageModelEntry* kkc_language_model_entry_dup (const KkcLanguageModelEntry* self) {
	KkcLanguageModelEntry* dup;
	dup = g_new0 (KkcLanguageModelEntry, 1);
	kkc_language_model_entry_copy (self, dup);
	return dup;
}


void kkc_language_model_entry_free (KkcLanguageModelEntry* self) {
	kkc_language_model_entry_destroy (self);
	g_free (self);
}


GType kkc_language_model_entry_get_type (void) {
	static volatile gsize kkc_language_model_entry_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_language_model_entry_type_id__volatile)) {
		GType kkc_language_model_entry_type_id;
		kkc_language_model_entry_type_id = g_boxed_type_register_static ("KkcLanguageModelEntry", (GBoxedCopyFunc) kkc_language_model_entry_dup, (GBoxedFreeFunc) kkc_language_model_entry_free);
		g_once_init_leave (&kkc_language_model_entry_type_id__volatile, kkc_language_model_entry_type_id);
	}
	return kkc_language_model_entry_type_id__volatile;
}


KkcLanguageModelMetadata* kkc_language_model_metadata_construct (GType object_type, const gchar* name, const gchar* filename, GError** error) {
	KkcLanguageModelMetadata * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = filename;
	self = (KkcLanguageModelMetadata*) kkc_metadata_file_construct (object_type, _tmp0_, _tmp1_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


KkcLanguageModelMetadata* kkc_language_model_metadata_new (const gchar* name, const gchar* filename, GError** error) {
	return kkc_language_model_metadata_construct (KKC_TYPE_LANGUAGE_MODEL_METADATA, name, filename, error);
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gboolean kkc_language_model_metadata_real_parse (KkcMetadataFile* base, JsonObject* object, GError** error) {
	KkcLanguageModelMetadata * self;
	gboolean result = FALSE;
	JsonObject* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	JsonNode* member = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonNode* _tmp4_ = NULL;
	JsonNode* _tmp5_ = NULL;
	gchar* type = NULL;
	JsonNode* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GeeMap* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GeeMap* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gpointer _tmp16_ = NULL;
	GType* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcLanguageModelMetadata*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = object;
	_tmp1_ = json_object_has_member (_tmp0_, "type");
	if (!_tmp1_) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new_literal (KKC_METADATA_FORMAT_ERROR, KKC_METADATA_FORMAT_ERROR_MISSING_FIELD, "type is not defined in metadata");
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp3_ = object;
	_tmp4_ = json_object_get_member (_tmp3_, "type");
	_tmp5_ = __vala_JsonNode_copy0 (_tmp4_);
	member = _tmp5_;
	_tmp6_ = member;
	_tmp7_ = json_node_get_string (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	type = _tmp8_;
	_tmp9_ = kkc_language_model_metadata_model_types;
	_tmp10_ = type;
	_tmp11_ = gee_map_has_key (_tmp9_, _tmp10_);
	if (!_tmp11_) {
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		_tmp12_ = type;
		_tmp13_ = g_error_new (KKC_METADATA_FORMAT_ERROR, KKC_METADATA_FORMAT_ERROR_INVALID_FIELD, "unknown language model type %s", _tmp12_);
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (type);
		__vala_JsonNode_free0 (member);
		return FALSE;
	}
	_tmp14_ = kkc_language_model_metadata_model_types;
	_tmp15_ = type;
	_tmp16_ = gee_map_get (_tmp14_, _tmp15_);
	_tmp17_ = (GType*) _tmp16_;
	kkc_language_model_metadata_set_model_type (self, *_tmp17_);
	_g_free0 (_tmp17_);
	result = TRUE;
	_g_free0 (type);
	__vala_JsonNode_free0 (member);
	return result;
}


KkcLanguageModelMetadata* kkc_language_model_metadata_find (const gchar* name) {
	KkcLanguageModelMetadata* result = NULL;
	gchar** dirs = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gint dirs_length1 = 0;
	gint _dirs_size_ = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp1_ = kkc_utils_build_data_path ("models", &_tmp0_);
	dirs = _tmp1_;
	dirs_length1 = _tmp0_;
	_dirs_size_ = dirs_length1;
	_tmp2_ = dirs;
	_tmp2__length1 = dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp2_;
		dir_collection_length1 = _tmp2__length1;
		for (dir_it = 0; dir_it < _tmp2__length1; dir_it = dir_it + 1) {
			gchar* _tmp3_ = NULL;
			gchar* dir = NULL;
			_tmp3_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp3_;
			{
				gchar* metadata_filename = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp4_ = dir;
				_tmp5_ = name;
				_tmp6_ = g_build_filename (_tmp4_, _tmp5_, "metadata.json", NULL);
				metadata_filename = _tmp6_;
				_tmp7_ = metadata_filename;
				_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
				if (_tmp8_) {
					{
						KkcLanguageModelMetadata* _tmp9_ = NULL;
						const gchar* _tmp10_ = NULL;
						const gchar* _tmp11_ = NULL;
						KkcLanguageModelMetadata* _tmp12_ = NULL;
						KkcLanguageModelMetadata* _tmp13_ = NULL;
						_tmp10_ = name;
						_tmp11_ = metadata_filename;
						_tmp12_ = kkc_language_model_metadata_new (_tmp10_, _tmp11_, &_inner_error_);
						_tmp9_ = _tmp12_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp13_ = _tmp9_;
						_tmp9_ = NULL;
						result = _tmp13_;
						_g_object_unref0 (_tmp9_);
						_g_free0 (metadata_filename);
						_g_free0 (dir);
						dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_g_error_free0 (e);
						_g_free0 (metadata_filename);
						_g_free0 (dir);
						continue;
					}
					__finally0:
					_g_free0 (metadata_filename);
					_g_free0 (dir);
					dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (metadata_filename);
				_g_free0 (dir);
			}
		}
	}
	result = NULL;
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


KkcLanguageModel* kkc_language_model_metadata_create_language_model (KkcLanguageModelMetadata* self, GError** error) {
	KkcLanguageModel* result = NULL;
	GObject* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	GObject* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_model_type;
	_tmp2_ = g_initable_new (_tmp1_, NULL, &_inner_error_, "metadata", self, NULL, NULL);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel);
	_g_object_unref0 (_tmp0_);
	return result;
}


GType kkc_language_model_metadata_get_model_type (KkcLanguageModelMetadata* self) {
	GType result;
	GType _tmp0_ = 0UL;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->_model_type;
	result = _tmp0_;
	return result;
}


void kkc_language_model_metadata_set_model_type (KkcLanguageModelMetadata* self, GType value) {
	GType _tmp0_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_model_type = _tmp0_;
	g_object_notify ((GObject *) self, "model-type");
}


static GType* _g_type_dup (GType* self) {
	GType* dup;
	dup = g_new0 (GType, 1);
	memcpy (dup, self, sizeof (GType));
	return dup;
}


static void kkc_language_model_metadata_class_init (KkcLanguageModelMetadataClass * klass) {
	GeeHashMap* _tmp0_ = NULL;
	GeeMap* _tmp1_ = NULL;
	GType _tmp2_ = 0UL;
	GeeMap* _tmp3_ = NULL;
	GType _tmp4_ = 0UL;
	GeeMap* _tmp5_ = NULL;
	GType _tmp6_ = 0UL;
	GeeMap* _tmp7_ = NULL;
	GType _tmp8_ = 0UL;
	kkc_language_model_metadata_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcLanguageModelMetadataPrivate));
	((KkcMetadataFileClass *) klass)->parse = kkc_language_model_metadata_real_parse;
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_language_model_metadata_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_language_model_metadata_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_language_model_metadata_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_LANGUAGE_MODEL_METADATA_MODEL_TYPE, g_param_spec_gtype ("model-type", "model-type", "model-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_GTYPE, (GBoxedCopyFunc) _g_type_dup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (kkc_language_model_metadata_model_types);
	kkc_language_model_metadata_model_types = (GeeMap*) _tmp0_;
	_tmp1_ = kkc_language_model_metadata_model_types;
	_tmp2_ = KKC_TYPE_TEXT_BIGRAM_LANGUAGE_MODEL;
	gee_map_set (_tmp1_, "text2", &_tmp2_);
	_tmp3_ = kkc_language_model_metadata_model_types;
	_tmp4_ = KKC_TYPE_TEXT_TRIGRAM_LANGUAGE_MODEL;
	gee_map_set (_tmp3_, "text3", &_tmp4_);
	_tmp5_ = kkc_language_model_metadata_model_types;
	_tmp6_ = KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL;
	gee_map_set (_tmp5_, "sorted2", &_tmp6_);
	_tmp7_ = kkc_language_model_metadata_model_types;
	_tmp8_ = KKC_TYPE_SORTED_TRIGRAM_LANGUAGE_MODEL;
	gee_map_set (_tmp7_, "sorted3", &_tmp8_);
}


static void kkc_language_model_metadata_instance_init (KkcLanguageModelMetadata * self) {
	self->priv = KKC_LANGUAGE_MODEL_METADATA_GET_PRIVATE (self);
}


static void kkc_language_model_metadata_finalize (GObject* obj) {
	KkcLanguageModelMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadata);
	G_OBJECT_CLASS (kkc_language_model_metadata_parent_class)->finalize (obj);
}


GType kkc_language_model_metadata_get_type (void) {
	static volatile gsize kkc_language_model_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_language_model_metadata_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcLanguageModelMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_language_model_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcLanguageModelMetadata), 0, (GInstanceInitFunc) kkc_language_model_metadata_instance_init, NULL };
		GType kkc_language_model_metadata_type_id;
		kkc_language_model_metadata_type_id = g_type_register_static (KKC_TYPE_METADATA_FILE, "KkcLanguageModelMetadata", &g_define_type_info, 0);
		g_once_init_leave (&kkc_language_model_metadata_type_id__volatile, kkc_language_model_metadata_type_id);
	}
	return kkc_language_model_metadata_type_id__volatile;
}


static void _vala_kkc_language_model_metadata_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcLanguageModelMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadata);
	switch (property_id) {
		case KKC_LANGUAGE_MODEL_METADATA_MODEL_TYPE:
		g_value_set_gtype (value, kkc_language_model_metadata_get_model_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_language_model_metadata_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcLanguageModelMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadata);
	switch (property_id) {
		case KKC_LANGUAGE_MODEL_METADATA_MODEL_TYPE:
		kkc_language_model_metadata_set_model_type (self, g_value_get_gtype (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GeeCollection* kkc_language_model_real_unigram_entries (KkcLanguageModel* self, const gchar* input) {
	g_critical ("Type `%s' does not implement abstract method `kkc_language_model_unigram_entries'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeCollection* kkc_language_model_unigram_entries (KkcLanguageModel* self, const gchar* input) {
	g_return_val_if_fail (self != NULL, NULL);
	return KKC_LANGUAGE_MODEL_GET_CLASS (self)->unigram_entries (self, input);
}


static GeeCollection* kkc_language_model_real_entries (KkcLanguageModel* self, const gchar* input) {
	g_critical ("Type `%s' does not implement abstract method `kkc_language_model_entries'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeCollection* kkc_language_model_entries (KkcLanguageModel* self, const gchar* input) {
	g_return_val_if_fail (self != NULL, NULL);
	return KKC_LANGUAGE_MODEL_GET_CLASS (self)->entries (self, input);
}


static KkcLanguageModelEntry* kkc_language_model_real_get (KkcLanguageModel* self, const gchar* input, const gchar* output) {
	g_critical ("Type `%s' does not implement abstract method `kkc_language_model_get'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


KkcLanguageModelEntry* kkc_language_model_get (KkcLanguageModel* self, const gchar* input, const gchar* output) {
	g_return_val_if_fail (self != NULL, NULL);
	return KKC_LANGUAGE_MODEL_GET_CLASS (self)->get (self, input, output);
}


KkcLanguageModel* kkc_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error) {
	KkcLanguageModel * self = NULL;
	KkcLanguageModelMetadata* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = metadata;
	self = (KkcLanguageModel*) g_object_new (object_type, "metadata", _tmp0_, NULL);
	g_initable_init ((GInitable*) self, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


static gboolean kkc_language_model_real_parse (KkcLanguageModel* self, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `kkc_language_model_parse'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean kkc_language_model_parse (KkcLanguageModel* self, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return KKC_LANGUAGE_MODEL_GET_CLASS (self)->parse (self, error);
}


static gboolean kkc_language_model_real_init (GInitable* base, GCancellable* cancellable, GError** error) {
	KkcLanguageModel * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (KkcLanguageModel*) base;
	kkc_language_model_parse (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


KkcLanguageModel* kkc_language_model_load (const gchar* name, GError** error) {
	KkcLanguageModel* result = NULL;
	KkcLanguageModelMetadata* metadata = NULL;
	const gchar* _tmp0_ = NULL;
	KkcLanguageModelMetadata* _tmp1_ = NULL;
	KkcLanguageModelMetadata* _tmp2_ = NULL;
	KkcLanguageModel* _tmp5_ = NULL;
	KkcLanguageModelMetadata* _tmp6_ = NULL;
	KkcLanguageModel* _tmp7_ = NULL;
	KkcLanguageModel* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = kkc_language_model_metadata_find (_tmp0_);
	metadata = _tmp1_;
	_tmp2_ = metadata;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp3_ = name;
		_tmp4_ = g_error_new (KKC_LANGUAGE_MODEL_ERROR, KKC_LANGUAGE_MODEL_ERROR_NOT_FOUND, "can't find language model %s", _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (metadata);
		return NULL;
	}
	_tmp6_ = metadata;
	_tmp7_ = kkc_language_model_metadata_create_language_model (_tmp6_, &_inner_error_);
	_tmp5_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (metadata);
		return NULL;
	}
	_tmp8_ = _tmp5_;
	_tmp5_ = NULL;
	result = _tmp8_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (metadata);
	return result;
}


KkcLanguageModelMetadata* kkc_language_model_get_metadata (KkcLanguageModel* self) {
	KkcLanguageModelMetadata* result;
	KkcLanguageModelMetadata* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_metadata;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void kkc_language_model_set_metadata (KkcLanguageModel* self, KkcLanguageModelMetadata* value) {
	KkcLanguageModelMetadata* _tmp0_ = NULL;
	KkcLanguageModelMetadata* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_metadata);
	self->priv->_metadata = _tmp1_;
	g_object_notify ((GObject *) self, "metadata");
}


void kkc_language_model_get_bos (KkcLanguageModel* self, KkcLanguageModelEntry* result) {
	g_return_if_fail (self != NULL);
	KKC_LANGUAGE_MODEL_GET_CLASS (self)->get_bos (self, result);
}


void kkc_language_model_get_eos (KkcLanguageModel* self, KkcLanguageModelEntry* result) {
	g_return_if_fail (self != NULL);
	KKC_LANGUAGE_MODEL_GET_CLASS (self)->get_eos (self, result);
}


static void kkc_language_model_class_init (KkcLanguageModelClass * klass) {
	kkc_language_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcLanguageModelPrivate));
	((KkcLanguageModelClass *) klass)->unigram_entries = kkc_language_model_real_unigram_entries;
	((KkcLanguageModelClass *) klass)->entries = kkc_language_model_real_entries;
	((KkcLanguageModelClass *) klass)->get = kkc_language_model_real_get;
	((KkcLanguageModelClass *) klass)->parse = kkc_language_model_real_parse;
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_language_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_language_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_language_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_LANGUAGE_MODEL_METADATA, g_param_spec_object ("metadata", "metadata", "metadata", KKC_TYPE_LANGUAGE_MODEL_METADATA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_LANGUAGE_MODEL_BOS, g_param_spec_boxed ("bos", "bos", "bos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_LANGUAGE_MODEL_EOS, g_param_spec_boxed ("eos", "eos", "eos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_language_model_g_initable_interface_init (GInitableIface * iface) {
	kkc_language_model_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) kkc_language_model_real_init;
}


static void kkc_language_model_instance_init (KkcLanguageModel * self) {
	self->priv = KKC_LANGUAGE_MODEL_GET_PRIVATE (self);
}


static void kkc_language_model_finalize (GObject* obj) {
	KkcLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel);
	_g_object_unref0 (self->priv->_metadata);
	G_OBJECT_CLASS (kkc_language_model_parent_class)->finalize (obj);
}


GType kkc_language_model_get_type (void) {
	static volatile gsize kkc_language_model_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_language_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcLanguageModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_language_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcLanguageModel), 0, (GInstanceInitFunc) kkc_language_model_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) kkc_language_model_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_language_model_type_id;
		kkc_language_model_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcLanguageModel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (kkc_language_model_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&kkc_language_model_type_id__volatile, kkc_language_model_type_id);
	}
	return kkc_language_model_type_id__volatile;
}


static void _vala_kkc_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel);
	switch (property_id) {
		case KKC_LANGUAGE_MODEL_METADATA:
		g_value_set_object (value, kkc_language_model_get_metadata (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_language_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel);
	switch (property_id) {
		case KKC_LANGUAGE_MODEL_METADATA:
		kkc_language_model_set_metadata (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


gdouble kkc_unigram_language_model_unigram_cost (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry) {
	g_return_val_if_fail (self != NULL, 0.0);
	return KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE (self)->unigram_cost (self, entry);
}


gdouble kkc_unigram_language_model_unigram_backoff (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry) {
	g_return_val_if_fail (self != NULL, 0.0);
	return KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE (self)->unigram_backoff (self, entry);
}


static void kkc_unigram_language_model_base_init (KkcUnigramLanguageModelIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType kkc_unigram_language_model_get_type (void) {
	static volatile gsize kkc_unigram_language_model_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_unigram_language_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcUnigramLanguageModelIface), (GBaseInitFunc) kkc_unigram_language_model_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType kkc_unigram_language_model_type_id;
		kkc_unigram_language_model_type_id = g_type_register_static (G_TYPE_INTERFACE, "KkcUnigramLanguageModel", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (kkc_unigram_language_model_type_id, KKC_TYPE_LANGUAGE_MODEL);
		g_once_init_leave (&kkc_unigram_language_model_type_id__volatile, kkc_unigram_language_model_type_id);
	}
	return kkc_unigram_language_model_type_id__volatile;
}


gboolean kkc_bigram_language_model_has_bigram (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	g_return_val_if_fail (self != NULL, FALSE);
	return KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE (self)->has_bigram (self, pentry, entry);
}


gdouble kkc_bigram_language_model_bigram_cost (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	g_return_val_if_fail (self != NULL, 0.0);
	return KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE (self)->bigram_cost (self, pentry, entry);
}


gdouble kkc_bigram_language_model_bigram_backoff (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	g_return_val_if_fail (self != NULL, 0.0);
	return KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE (self)->bigram_backoff (self, pentry, entry);
}


gdouble kkc_bigram_language_model_bigram_backoff_cost (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	gdouble result = 0.0;
	KkcLanguageModelEntry _tmp0_ = {0};
	KkcLanguageModelEntry _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gdouble backoff = 0.0;
	KkcLanguageModelEntry _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	gdouble cost = 0.0;
	KkcLanguageModelEntry _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *pentry;
	_tmp1_ = *entry;
	_tmp2_ = kkc_bigram_language_model_has_bigram (self, &_tmp0_, &_tmp1_);
	if (_tmp2_) {
		KkcLanguageModelEntry _tmp3_ = {0};
		KkcLanguageModelEntry _tmp4_ = {0};
		gdouble _tmp5_ = 0.0;
		_tmp3_ = *pentry;
		_tmp4_ = *entry;
		_tmp5_ = kkc_bigram_language_model_bigram_cost (self, &_tmp3_, &_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = *pentry;
	_tmp7_ = kkc_unigram_language_model_unigram_backoff ((KkcUnigramLanguageModel*) self, &_tmp6_);
	backoff = _tmp7_;
	_tmp8_ = *entry;
	_tmp9_ = kkc_unigram_language_model_unigram_cost ((KkcUnigramLanguageModel*) self, &_tmp8_);
	cost = _tmp9_;
	_tmp10_ = backoff;
	_tmp11_ = cost;
	result = _tmp10_ + _tmp11_;
	return result;
}


static void kkc_bigram_language_model_base_init (KkcBigramLanguageModelIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType kkc_bigram_language_model_get_type (void) {
	static volatile gsize kkc_bigram_language_model_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_bigram_language_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcBigramLanguageModelIface), (GBaseInitFunc) kkc_bigram_language_model_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType kkc_bigram_language_model_type_id;
		kkc_bigram_language_model_type_id = g_type_register_static (G_TYPE_INTERFACE, "KkcBigramLanguageModel", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (kkc_bigram_language_model_type_id, KKC_TYPE_UNIGRAM_LANGUAGE_MODEL);
		g_once_init_leave (&kkc_bigram_language_model_type_id__volatile, kkc_bigram_language_model_type_id);
	}
	return kkc_bigram_language_model_type_id__volatile;
}


gboolean kkc_trigram_language_model_has_trigram (KkcTrigramLanguageModel* self, KkcLanguageModelEntry* ppentry, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	g_return_val_if_fail (self != NULL, FALSE);
	return KKC_TRIGRAM_LANGUAGE_MODEL_GET_INTERFACE (self)->has_trigram (self, ppentry, pentry, entry);
}


gdouble kkc_trigram_language_model_trigram_cost (KkcTrigramLanguageModel* self, KkcLanguageModelEntry* ppentry, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	g_return_val_if_fail (self != NULL, 0.0);
	return KKC_TRIGRAM_LANGUAGE_MODEL_GET_INTERFACE (self)->trigram_cost (self, ppentry, pentry, entry);
}


gdouble kkc_trigram_language_model_trigram_backoff_cost (KkcTrigramLanguageModel* self, KkcLanguageModelEntry* ppentry, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	gdouble result = 0.0;
	KkcLanguageModelEntry _tmp0_ = {0};
	KkcLanguageModelEntry _tmp1_ = {0};
	KkcLanguageModelEntry _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	gdouble backoff = 0.0;
	KkcLanguageModelEntry _tmp8_ = {0};
	KkcLanguageModelEntry _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
	gdouble cost = 0.0;
	KkcLanguageModelEntry _tmp11_ = {0};
	KkcLanguageModelEntry _tmp12_ = {0};
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	g_return_val_if_fail (ppentry != NULL, 0.0);
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *ppentry;
	_tmp1_ = *pentry;
	_tmp2_ = *entry;
	_tmp3_ = kkc_trigram_language_model_has_trigram (self, &_tmp0_, &_tmp1_, &_tmp2_);
	if (_tmp3_) {
		KkcLanguageModelEntry _tmp4_ = {0};
		KkcLanguageModelEntry _tmp5_ = {0};
		KkcLanguageModelEntry _tmp6_ = {0};
		gdouble _tmp7_ = 0.0;
		_tmp4_ = *ppentry;
		_tmp5_ = *pentry;
		_tmp6_ = *entry;
		_tmp7_ = kkc_trigram_language_model_trigram_cost (self, &_tmp4_, &_tmp5_, &_tmp6_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = *ppentry;
	_tmp9_ = *pentry;
	_tmp10_ = kkc_bigram_language_model_bigram_backoff ((KkcBigramLanguageModel*) self, &_tmp8_, &_tmp9_);
	backoff = _tmp10_;
	_tmp11_ = *pentry;
	_tmp12_ = *entry;
	_tmp13_ = kkc_bigram_language_model_bigram_backoff_cost ((KkcBigramLanguageModel*) self, &_tmp11_, &_tmp12_);
	cost = _tmp13_;
	_tmp14_ = backoff;
	_tmp15_ = cost;
	result = _tmp14_ + _tmp15_;
	return result;
}


static void kkc_trigram_language_model_base_init (KkcTrigramLanguageModelIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType kkc_trigram_language_model_get_type (void) {
	static volatile gsize kkc_trigram_language_model_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_trigram_language_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcTrigramLanguageModelIface), (GBaseInitFunc) kkc_trigram_language_model_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType kkc_trigram_language_model_type_id;
		kkc_trigram_language_model_type_id = g_type_register_static (G_TYPE_INTERFACE, "KkcTrigramLanguageModel", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (kkc_trigram_language_model_type_id, KKC_TYPE_BIGRAM_LANGUAGE_MODEL);
		g_once_init_leave (&kkc_trigram_language_model_type_id__volatile, kkc_trigram_language_model_type_id);
	}
	return kkc_trigram_language_model_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



