/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef __IXION_FORMULA_FUNCTION_OPCODE_HPP__
#define __IXION_FORMULA_FUNCTION_OPCODE_HPP__

namespace ixion {

enum formula_function_t
{
    func_unknown = 0,

    // statistical functions
    func_max,
    func_min,
    func_average,
    func_sum,

    // logical functions
    func_if,

    // string functions
    func_len,
    func_concatenate,

    // date & time functions
    func_now,

    func_wait // dummy function used only for testing.

    // TODO: more functions to come...
};

bool is_volatile(formula_function_t func);

}

#endif
/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
