/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: GroupVisitor.java,v 1.5 2005/06/15 23:43:00 pietschy Exp $
 */

package org.pietschy.command;

/**
 * And interface for visiting the members of a {@link CommandGroup}.
 */
public interface
GroupVisitor
{
   /**
    * Called to visit a {@link ActionCommand} member of a {@link CommandGroup}.
    * @param command the member being visited.
    */
   public void
   visit(ActionCommand command);

   /**
    * Called to visit a {@link CommandGroup} member of a {@link CommandGroup}.
    * @param group the member being visited.
    */
   public void
   visit(CommandGroup group);

}
