/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: CompoundIterator.java,v 1.3 2004/12/12 05:29:20 pietschy Exp $
 */

package org.pietschy.command;

import java.util.Iterator;

class
CompoundIterator
implements Iterator
{
   Iterator[] iterators;
   int iterIndex = 0;

   Object next = null;

   protected CompoundIterator(Iterator[] iterators)
   {
      this.iterators = iterators;
   }

   public boolean hasNext()
   {
      if (next != null)
         return true;

      // find the next one...
      while (next == null && iterIndex < iterators.length)
      {
         if (iterators[iterIndex].hasNext())
         {
            next = iterators[iterIndex].next();
         }
         else
         {
            iterIndex++;
         }
      }

      return (next != null);
   }

   public Object next()
   {
      if (next == null)
         throw new IllegalStateException("");

      Object temp = next;
      next = null;
      return temp;
   }

   public void remove()
   {
      throw new UnsupportedOperationException("");
   }
}
