package org.gnu.gtk.event;

import org.gnu.glib.EventType;

/**
 * An event representing the activation of an {@link org.gnu.gtk.Action} object
 * 
 * @since 2.8
 * @author ajocksch
 */
public class ActionEvent extends GtkEvent {

    /**
     * The type of the ActionEvent
     * 
     * @author ajocksch
     * 
     */
    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        /**
         * The Action was activated
         */
        public static Type ACTIVATE = new Type(1, "ACTIVATE");
    }

    /**
     * creates a new ActionEvent
     * 
     * @param source
     * @param type
     */
    public ActionEvent(Object source, EventType type) {
        super(source, type);
    }

    /**
     * Compares this event's type with the provided type
     * 
     * @param aType
     *            The type to test against
     * @return true if this event has the same type as aType
     */
    public boolean isOfType(ActionEvent.Type aType) {
        return (type.getID() == aType.getID());
    }

}
