require 'mkmf'

if /mingw/ =~ RUBY_PLATFORM
  GSL_CONFIG = "sh gsl-config"
else
  GSL_CONFIG = "gsl-config"
end

def gsl_config()
  print("checking gsl cflags... ")
  IO.popen("#{GSL_CONFIG} --cflags") do |f|
    cflags = f.gets.chomp
    puts(cflags)
    $CFLAGS += " " + cflags
  end
   
  IO.popen("#{GSL_CONFIG} --libs") do |f|
    libs = f.gets.chomp
    dir_config("cblas")
    dir_config("atlas")
    if have_library("cblas") and have_library("atlas")
      libs.gsub!("-lgslcblas", "-lcblas -latlas")
      $LOCAL_LIBS += " " + libs.gsub(" -lgslcblas", "")
      print("checking gsl libs... ")
      puts(libs)
    else
      print("checking gsl libs... ")
      puts(libs)
      $LOCAL_LIBS += " " + libs
    end
  end

end

def check_version(configfile)
  
  print("checking gsl version... ")
  IO.popen("#{GSL_CONFIG} --version") do |f|
    ver = f.gets.chomp
    puts(ver)
    configfile.printf("#ifndef GSL_VERSION\n#define GSL_VERSION \"#{ver}\"\n#endif\n")
    if ver >= "0.9.4"
      configfile.printf("#ifndef GSL_0_9_4_LATER\n#define GSL_0_9_4_LATER\n#endif\n")
    else
      configfile.close
      raise("Ruby/GSL requires gsl-0.9.4 or later.")
    end
    if ver >= "1.0"
      configfile.printf("#ifndef GSL_1_0_LATER\n#define GSL_1_0_LATER\n#endif\n")
    end
    if ver >= "1.1"
      configfile.printf("#ifndef GSL_1_1_LATER\n#define GSL_1_1_LATER\n#endif\n")
    end
    if ver >= "1.1.1"
      configfile.printf("#ifndef GSL_1_1_1_LATER\n#define GSL_1_1_1_LATER\n#endif\n")
    end
    if ver >= "1.2"
      configfile.printf("#ifndef GSL_1_2_LATER\n#define GSL_1_2_LATER\n#endif\n")
    end
    if ver >= "1.3"
      configfile.printf("#ifndef GSL_1_3_LATER\n#define GSL_1_3_LATER\n#endif\n")
    end
    if ver >= "1.4"
      configfile.printf("#ifndef GSL_1_4_LATER\n#define GSL_1_4_LATER\n#endif\n")
    end
    if ver >= "1.4.90"
      configfile.printf("#ifndef GSL_1_4_9_LATER\n#define GSL_1_4_9_LATER\n#endif\n")
    end
    
    if ver >= "1.5.90"
      configfile.printf("#ifndef GSL_1_6_LATER\n#define GSL_1_6_LATER\n#endif\n")
    end

    if ver >= "1.7.90"
      configfile.printf("#ifndef GSL_1_8_LATER\n#define GSL_1_8_LATER\n#endif\n")
    end

    if ver < "1.4"
      configfile.printf("#ifndef GSL_CONST_OLD\n#define GSL_CONST_OLD\n#endif\n")
    end

  end
end

#####

$CFLAGS = "-I../include"

begin
  RB_GSL_CONFIG = File.open("../include/rb_gsl_config.h", "w")
  RB_GSL_CONFIG.printf("#ifndef ___RB_GSL_CONFIG_H___\n")
  RB_GSL_CONFIG.printf("#define ___RB_GSL_CONFIG_H___\n\n")
  
  check_version(RB_GSL_CONFIG)

  gsl_config()

  if have_header("rngextra/rngextra.h")
    have_library("rngextra")
  end

  if have_header("gsl_tensor/gsl_tensor.h")
    have_library("gsltensor")
  end
 
  begin
    print("checking rb-gsl version...")
    IO.popen("cat ../VERSION") do |f|
      ver = f.gets.chomp
      puts(ver)
      RB_GSL_CONFIG.printf("#ifndef RUBY_GSL_VERSION\n#define RUBY_GSL_VERSION \"#{ver}\"\n#endif\n")
    end
  end
  
  puts("checking ruby version... #{RUBY_VERSION}")
  if RUBY_VERSION >= "1.8"
    RB_GSL_CONFIG.printf("#ifndef RUBY_1_8_LATER\n#define RUBY_1_8_LATER\n#endif\n")
    if find_executable("graph")
      RB_GSL_CONFIG.printf("#ifndef HAVE_GNU_GRAPH\n#define HAVE_GNU_GRAPH\n#endif\n")
    end
  else
    path = (path || ENV['PATH']).split(File::PATH_SEPARATOR)  
    flag = 0
    print("checking for GNU graph... ")
    path.each do |dir|    
      if File.executable?(file = File.join(dir, "graph")) 
        puts("yes")
        RB_GSL_CONFIG.printf("#ifndef HAVE_GNU_GRAPH\n#define HAVE_GNU_GRAPH\n#endif\n")
        flag = 1
        break
      end
    end
    puts("no") if flag == 0
  end
  if RUBY_VERSION >= "1.9"
    RB_GSL_CONFIG.printf("#ifndef RUBY_1_9_LATER\n#define RUBY_1_9_LATER\n#endif\n")
  end

  RB_GSL_CONFIG.printf("\n#endif\n")
  RB_GSL_CONFIG.close
  
rescue
  raise("Check GSL>=0.9.4 is installed, and the command \"gsl-config\" is in search path.")
end

#narray_config = dir_config("narray")
narray_config = dir_config('narray',$sitearchdir,$sitearchdir)
have_narray_h = have_header("narray.h")
if narray_config
  if RUBY_PLATFORM =~ /cygwin|mingw/
    have_library("narray") || raise("ERROR: narray import library is not found")
  end
end

tamu_anova_config = dir_config('tamu_anova',$sitearchdir,$sitearchdir)
have_tamu_anova_h = have_header("tamu_anova/tamu_anova.h")
if tamu_anova_config
  have_library("tamuanova")
#  if RUBY_PLATFORM =~ /cygwin|mingw/
#    have_library("tamuanova") || raise("ERROR: tamu_anova import library is not found")
#  end
end

have_func("round")

File.open("../lib/gsl.rb", "w") do |file|
  if have_narray_h
    file.print("require\(\"narray\"\)\n")
  end
  file.print("require\(\"rb_gsl\"\)\ninclude GSL\n")
  file.print("require\(\"gsl/oper.rb\"\)\n")
end

File.open("../lib/rbgsl.rb", "w") do |file|
  if have_narray_h
    file.print("require\(\"narray\"\)\n")
  end
  file.print("require\(\"rb_gsl\"\)\n")
  file.print("require\(\"gsl/oper.rb\"\)\n")
end

srcs = %w(
array 
array_complex 
blas 
blas1 
blas2 
blas3 
block
cdf 
cheb 
combination 
common 
complex 
const 
const_additional 
deriv
dirac
dht 
diff 
eigen 
error 
fcmp 
fft 
fit 
function 
graph 
gsl 
gsl_narray 
histogram 
histogram_oper
histogram2d 
histogram_find
histogram3d_source
histogram3d
ieee 
integration 
interp 
linalg 
linalg_complex 
math 
matrix 
matrix_complex 
matrix_double 
matrix_int 
min 
monte 
multifit 
multimin 
multiroots 
ntuple 
odeiv 
oper_complex_source 
permutation 
poly 
poly2 
qrng 
randist 
rational 
rng 
root 
sf 
sf_airy 
sf_bessel 
sf_clausen 
sf_coulomb 
sf_coupling 
sf_dawson 
sf_debye 
sf_dilog 
sf_elementary 
sf_ellint 
sf_elljac 
sf_erfc 
sf_exp 
sf_expint 
sf_fermi_dirac 
sf_gamma 
sf_gegenbauer 
sf_hyperg 
sf_laguerre 
sf_lambert 
sf_legendre 
sf_log 
sf_power 
sf_psi 
sf_synchrotron 
sf_transport 
sf_trigonometric 
sf_zeta 
siman 
sort 
spline 
stats 
sum 
tamu_anova
tensor
vector 
vector_complex 
vector_double 
vector_int 
wavelet 
)

$objs = srcs.collect{|i| i+".o"}

create_makefile("rb_gsl")
