/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Network.cc,v 1.3 2001/12/19 12:46:59 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <fwbuilder/Network.hh>

#include <fwbuilder/XMLTools.hh>

using namespace libfwbuilder;

const char *Network::TYPENAME={"Network"};

Network::Network() : FWObject() , 
		     address("0.0.0.0") , 
		     netmask("0.0.0.0")
{
}

Network::Network(Network &o) : FWObject(o) , 
			       address(o.getAddress()) , 
			       netmask(o.getNetmask())
{
}

Network& Network::operator=(const FWObject &o)
{
    const Network &n=dynamic_cast<const Network &>(o);
    address=n.getAddress();
    netmask=n.getNetmask();
    FWObject::operator=(n);
    return *this;
}

FWObject& Network::duplicate(const FWObject *o)
{
    const Network *n=dynamic_cast<const Network *>(o);
    address=n->getAddress();
    netmask=n->getNetmask();
    FWObject::duplicate(o);
    return *this;
}

void Network::fromXML(xmlNodePtr root)
{
    FWObject::fromXML(root);
    
    const char *n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("address")));
    assert(n!=NULL);
    address = n;

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("netmask")));
    assert(n!=NULL);
    netmask = n;
}

xmlNodePtr Network::toXML(xmlNodePtr xml_parent_node)
{
    xmlNodePtr me = FWObject::toXML(xml_parent_node);
    
    xmlNewProp(me, 
               TOXMLCAST("address"),
               STRTOXMLCAST(address.toString()));
    
    xmlNewProp(me, 
               TOXMLCAST("netmask"),
               STRTOXMLCAST(netmask.toString()));
    
    return me;
}

// --- Iterator ---


/*
  Network::iterator& Network::begin() 
  { 
  return ; 
  }

  Network::iterator& Network::end() 
  { 
  return ; 
  }
*/

Network::iterator& Network::iterator::operator*() 
{ 
    return *this; 
}

Network::iterator& Network::iterator::operator++()  
{ 
    return *this; 
}

bool Network::iterator::operator==(const Network::iterator &x) 
{ 
    return false; 
}

Network::iterator::iterator() {}

