/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWReference.cc,v 1.3 2001/12/19 12:46:17 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <fwbuilder/FWReference.hh>
#include <fwbuilder/FWObjectDatabase.hh>
#include <fwbuilder/XMLTools.hh>

using namespace libfwbuilder;

const char *FWReference::TYPENAME={"Ref"};

FWReference::FWReference(FWObject *p)
{
    setPointer(p);

    remStr("name");
    remStr("comment");
    remStr("id");
}

FWReference::FWReference()
{
    remStr("name");
    remStr("comment");
    remStr("id");
    setPointer(NULL);
}

FWReference::~FWReference()  {}


void FWReference::fromXML(xmlNodePtr root) 
{
    assert(root!=NULL);
    FWObject::fromXML(root);

    const char *n = FROMXMLCAST(xmlGetProp(root,TOXMLCAST("ref")));
    assert(n!=NULL);
    setStr("ref", n);
}

void FWReference::add(FWObject *obj)
{
    throw std::string("Can't add to a reference !");
}

void FWReference::setPointer(FWObject *p)
{
    if(p)
        setStr("ref" , p->getId()  );
}

FWObject *FWReference::getPointer()
{
    FWObject *ptr;

    ptr=getRoot()->getById( getStr("ref"),true );

    return ptr;
}


#ifdef _REF_DUMP_
void   FWReference::dump(int offset)
{
    FWObject::dump(offset);

    FWObject* ptr=getPointer();

    cout << string(offset,' ') << "Pointer: " << ptr << endl;
    if (ptr) {
	cout<< string(offset,' ') << "Ptr.name: " << ptr->getName() <<endl;
	cout<< string(offset,' ') << "Ptr.id: "   << ptr->getId() <<endl;
    }
}
#endif




















