/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

/* url.h  -- Henry Thompson
 *
 * $Header: /cvs/flux/src/xml/url.h,v 1.3 1999/12/14 04:06:04 hpj Exp $
 */

#ifndef _URL_H
#define _URL_H

#include <stdio.h>
#include "stdio16.h"
#include "charset.h"

extern STD_API char8 * EXPRT 
    url_merge(const char8 *url, const char8 *base,
        char8 **scheme, char8 **host, int *port, char8 **path);
extern STD_API FILE16 *url_open(const char8 *url, const char8 *base, 
          const char8 *type, char8 **merged_url);
extern STD_API char8 *EXPRT default_base_url(void);

#endif
