/* 
 * $Id: ctktogglebutton.h,v 1.10 2000/07/14 01:40:08 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTK_TOGGLE_BUTTON_H__
# define __CTK_TOGGLE_BUTTON_H__ 

typedef struct CtkToggleButton_S {
	CtkButton button;
	gboolean  active;
} CtkToggleButton;

CtkWidget *ctk_toggle_button_new_with_label(const gchar *label);
CtkWidget *ctk_toggle_button_new();

void ctk_toggle_button_init(CtkToggleButton *button);
void ctk_toggle_button_toggled(CtkToggleButton *button);
void ctk_toggle_button_set_active(CtkToggleButton *toggle_button,
				  gboolean is_active);
gboolean ctk_toggle_button_get_active(CtkToggleButton* toggle_button);

# define CTK_TOGGLE_BUTTON(obj)	CTK_CHECK_CAST((obj),CtkToggleButton,CtkTypeToggleButton)

#endif
