-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2002 Hans-Frieder Vogt                                --
--                                                                           --
--  Adabindx is free software; you can redistribute it and/or modify it      --
--  under the terms of the GNU General Public License as published by the    --
--  Free Software Foundation; either version 2 of the License, or (at your   --
--  option) any later version.                                               --
--                                                                           --
--  This program is distributed in the hope that it will be useful, but      --
--  WITHOUT ANY WARRANTY; without even the implied warranty of               --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--  As a special exception, if other files instantiate generics from this    --
--  unit, or you link this unit with other files to produce an executable,   --
--  this unit does not by itself cause the resulting executable to be        --
--  covered by the GNU General Public License. This exception does not       --
--  however invalidate any other reasons why the executable file might be    --
--  covered by the GNU General Public License.                               --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                  and by The Open Group                                    --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          July 30, 1999 begin of history
--
-------------------------------------------------------------------------------

with Ada.Text_Io,
     X_Command_Line,
     X_Lib.Extensions.Print;
procedure Show_Printers is

   Print_Display : X_lib.Display_Pointer;
   First_Event   : X_Lib.Event_Type;
   First_Error   : X_Lib.Error_Code_Type;

   type String_Access is access all String;

   Display_Name  : String_Access := null;
   Next_Is_Display_Name : Boolean := False;


   procedure Print_Help is
      use Ada.Text_Io;
   begin
      Set_Output (Standard_Error);
      New_Line;
      Put_Line ("Show_Printers -- (c)1999,2002 Hans-Frieder Vogt");
      Put_Line ("informs about printers available through the X-Print-Server");
      New_Line;
      Put_Line ("   Usage:");
      Put_Line ("          " & X_Command_Line.Command_Name & " [-display Display]");
      Set_Output (Standard_Output);
   end Print_Help;

begin
   --  first process command line
   for I in 1 .. X_Command_Line.Argument_Count loop
      if X_Command_Line.Argument (I) = "-help" then
         Print_Help;
	 exit;
      elsif X_Command_Line.Argument (I) = "-display" then
         Next_Is_Display_Name := True;
      else
         if Next_Is_Display_Name then
	    Display_Name := new String'(X_Command_Line.Argument (I));
         else
            Ada.Text_Io.Put_Line (Ada.Text_Io.Standard_Error,
              "WARNING: Unknown command line switch (use -help to learn more)");
         end if;
	 Next_Is_Display_Name := False;
      end if;
   end loop;

   --  try to connect to the X Server
   --
   if Display_Name = null then
      Print_Display := X_Lib.X_Open_Display;
   else
      Print_Display := X_Lib.X_Open_Display (Display_Name.all);
   end if;

   --  look, if the XpExtension is available
   --
   X_Lib.Extensions.Print.Xp_Query_Extension (Print_Display,
                                              First_Event,
                                              First_Error);

   Ada.Text_Io.Put_Line ("current locale: """ &
                         X_Lib.Extensions.Print.Xp_Get_Locale_Net_String &
			 """");
   declare
      List : constant X_Lib.Extensions.Print.Printer_List
           := X_Lib.Extensions.Print.Xp_Get_Printer_List (Print_Display);
   begin
      if List'Length > 0 then
         Ada.Text_Io.Put (Integer'Image (List'Length));
         if List'Length > 1 then
            Ada.Text_Io.Put (" printers");
	 else
            Ada.Text_Io.Put (" printer");
         end if;
         Ada.Text_Io.Put_Line (" available through display " &
	                          X_Lib.X_Display_String (Print_Display));
         Ada.Text_Io.New_Line;
         Ada.Text_Io.Put_Line ("    Printer:    Description:");
         for I in List'Range loop
	    Ada.Text_Io.Put_Line (Integer'Image (I) & ": " &
	                          List (I).Name.all & "   " &
				  List (I).Desc.all);
	 end loop;
         Ada.Text_Io.New_Line;
      else
         Ada.Text_Io.Put_Line ("No printers available");
      end if;
   end;

   X_Lib.X_Close_Display (Print_Display);
exception
   when X_Lib.No_Connection_Error =>
      Ada.Text_Io.Put_Line (Ada.Text_Io.Standard_Error,
         "ERROR: Couldn't connect to X Server (correct DISPLAY Variable?)");
   when X_Lib.Extensions.Extension_Not_Existent_Error =>
      Ada.Text_Io.Put_Line (Ada.Text_Io.Standard_Error,
         "ERROR: Server has no XpExtension (Print Extension)");
      Ada.Text_Io.Put_Line (Ada.Text_Io.Standard_Error,
	 "       Did you select the right display (choose -display option)?");
end Show_Printers;
