/* gtkscrollbarpeer.c -- Native implementation of GtkScrollbarPeer
   Copyright (C) 1998, 1999 Free Software Foundation, Inc.

This file is part of the peer AWT libraries of GNU Classpath.

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published 
by the Free Software Foundation, either version 2 of the License, or
(at your option) any later verion.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; if not, write to the Free Software Foundation
Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA. */


#include "gtkpeer.h"
#include "gnu_java_awt_peer_gtk_GtkScrollbarPeer.h"

struct range_scrollbar
{
  GtkRange *range;
  jobject *scrollbar;
};

static void 
post_adjustment_event (GtkAdjustment *adj, struct range_scrollbar *rs)
{
  jint type;

  switch (rs->range->scroll_type)
    {
    case GTK_SCROLL_STEP_FORWARD:
      type = AWT_ADJUSTMENT_UNIT_INCREMENT;
      break;
    case GTK_SCROLL_STEP_BACKWARD:
      type = AWT_ADJUSTMENT_UNIT_DECREMENT;
      break;
    case GTK_SCROLL_PAGE_FORWARD:
      type = AWT_ADJUSTMENT_BLOCK_INCREMENT;
      break;
    case GTK_SCROLL_PAGE_BACKWARD:
      type = AWT_ADJUSTMENT_BLOCK_DECREMENT;
      break;
    case GTK_SCROLL_JUMP:
      type = AWT_ADJUSTMENT_TRACK;
      break;
    default: /* GTK_SCROLL_NONE */
      return;
    }
  
  (*gdk_env)->CallVoidMethod (gdk_env, *(rs->scrollbar), postAdjustmentEventID,
			      type, (jint) adj->value);
}

JNIEXPORT void JNICALL 
Java_gnu_java_awt_peer_gtk_GtkScrollbarPeer_create
(JNIEnv *env, jobject obj, jint orientation, jint value, 
 jint min, jint max, jint step_incr, jint page_incr, jint visible_amount)
{
  GtkWidget *sb;
  GtkObject *adj;

  gdk_threads_enter ();
  adj = gtk_adjustment_new (value, min, max, 
			    step_incr, page_incr, 
			    visible_amount);

  sb = (orientation) ? gtk_vscrollbar_new (GTK_ADJUSTMENT (adj)) :
                       gtk_hscrollbar_new (GTK_ADJUSTMENT (adj));
  gdk_threads_leave ();

  NSA_SET_PTR (env, obj, sb);
}

JNIEXPORT void JNICALL
Java_gnu_java_awt_peer_gtk_GtkScrollbarPeer_connectHooks
  (JNIEnv *env, jobject obj)
{
  void *ptr;
  struct range_scrollbar *rs;

  rs = (struct range_scrollbar *) malloc (sizeof (struct range_scrollbar));

  ptr = NSA_GET_PTR (env, obj);

  gdk_threads_enter ();
  gtk_widget_realize (GTK_WIDGET (ptr));

  rs->range = GTK_RANGE (ptr);
  rs->scrollbar = (jobject *) malloc (sizeof (jobject));
  *(rs->scrollbar) = (*env)->NewGlobalRef (env, obj);
  gtk_signal_connect (GTK_OBJECT (GTK_RANGE (ptr)->adjustment), 
		      "value_changed", 
		      GTK_SIGNAL_FUNC (post_adjustment_event), rs);

  connect_awt_hook (env, obj, 4, 
		    GTK_RANGE (ptr)->trough,
		    GTK_RANGE (ptr)->slider,
		    GTK_RANGE (ptr)->step_forw,
		    GTK_RANGE (ptr)->step_back);
  gdk_threads_leave ();
}


JNIEXPORT void JNICALL 
Java_gnu_java_awt_peer_gtk_GtkScrollbarPeer_setLineIncrement
    (JNIEnv *env, jobject obj, jint amount)
{
  void *ptr;
  GtkAdjustment *adj;

  ptr = NSA_GET_PTR (env, obj);

  gdk_threads_enter ();

  adj = GTK_RANGE (ptr)->adjustment;
  adj->step_increment = amount;
  gtk_adjustment_changed (adj);

  gdk_threads_leave ();
}

JNIEXPORT void JNICALL 
Java_gnu_java_awt_peer_gtk_GtkScrollbarPeer_setPageIncrement
    (JNIEnv *env, jobject obj, jint amount)
{
  void *ptr;
  GtkAdjustment *adj;

  ptr = NSA_GET_PTR (env, obj);

  gdk_threads_enter ();

  adj = GTK_RANGE (ptr)->adjustment;
  adj->page_increment = amount;
  gtk_adjustment_changed (adj);

  gdk_threads_leave ();
}

JNIEXPORT void JNICALL 
Java_gnu_java_awt_peer_gtk_GtkScrollbarPeer_setValues
    (JNIEnv *env, jobject obj, jint value, jint visible, jint min, jint max)
{
  void *ptr;
  GtkAdjustment *adj;

  ptr = NSA_GET_PTR (env, obj);

  gdk_threads_enter ();

  adj = GTK_RANGE (ptr)->adjustment;
  adj->value = value;
  adj->page_size = visible;
  adj->lower = min;
  adj->upper = max;
  gtk_adjustment_changed (adj);

  gdk_threads_leave ();
}
