/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class ApplyXPath {
    protected String filename = null;
    protected String xpath = null;

    public void doMain(String[] stringArray) throws Exception {
        this.filename = stringArray[0];
        this.xpath = stringArray[1];
        if (this.filename != null && this.filename.length() > 0 && this.xpath != null && this.xpath.length() > 0) {
            Node node;
            System.out.println("Loading classes, parsing " + this.filename + ", and setting up serializer");
            InputSource inputSource = new InputSource(new FileInputStream(this.filename));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            System.out.println("Querying DOM using " + this.xpath);
            NodeIterator nodeIterator = XPathAPI.selectNodeIterator((Node)document, (String)this.xpath);
            System.out.println("<output>");
            while ((node = nodeIterator.nextNode()) != null) {
                transformer.transform(new DOMSource(node), new StreamResult(System.out));
                System.out.println();
            }
            System.out.println("</output>");
        } else {
            System.out.println("Bad input args: " + this.filename + ", " + this.xpath);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("java ApplyXPath filename.xml xpath\nReads filename.xml and applies the xpath; prints the nodelist found.");
            return;
        }
        ApplyXPath applyXPath = new ApplyXPath();
        applyXPath.doMain(stringArray);
    }
}

