/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import org.enhydra.instantdb.db.BlobColumn;
import org.enhydra.instantdb.db.ByteColumn;
import org.enhydra.instantdb.db.Database;
import org.enhydra.instantdb.db.DateColumn;
import org.enhydra.instantdb.db.DoubleColumn;
import org.enhydra.instantdb.db.FloatColumn;
import org.enhydra.instantdb.db.Importer;
import org.enhydra.instantdb.db.IntegerColumn;
import org.enhydra.instantdb.db.LongColumn;
import org.enhydra.instantdb.db.StringColumn;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Transaction;

class JdbcImporter
implements Importer {
    Connection con;
    Statement stmt;
    ResultSet rs;
    ResultSetMetaData rsmd;
    int numCols;
    int[] colTypes;

    JdbcImporter(Database database, String string, String string2, Table table, Transaction transaction, Properties properties) throws SQLException {
        String string3 = table.getTableName();
        String string4 = properties.getProperty(String.valueOf(string3) + "%username");
        String string5 = properties.getProperty(String.valueOf(string3) + "$password");
        this.con = string4 != null ? DriverManager.getConnection(string, string4, string5) : DriverManager.getConnection(string, database.defaultUsername, database.defaultPassword);
        this.stmt = this.con.createStatement();
        this.rs = this.stmt.executeQuery(string2);
        this.rsmd = this.rs.getMetaData();
        this.numCols = this.rsmd.getColumnCount();
        this.colTypes = new int[this.numCols + 1];
        if (table.getColCount() > 1) {
            return;
        }
        int n = 1;
        while (n <= this.numCols) {
            String string6 = this.rsmd.getColumnLabel(n);
            this.colTypes[n] = this.rsmd.getColumnType(n);
            int n2 = this.rsmd.getColumnDisplaySize(n);
            if (n2 > 65536) {
                n2 = 256;
            }
            switch (this.colTypes[n]) {
                case 1: 
                case 12: {
                    new StringColumn(table, string6, n2);
                    break;
                }
                case -7: 
                case -6: {
                    new ByteColumn(table, string6);
                    break;
                }
                case 4: 
                case 5: {
                    new IntegerColumn(table, string6);
                    break;
                }
                case -5: {
                    new LongColumn(table, string6);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    new DateColumn(table, string6, transaction.dateFormat);
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    new DoubleColumn(table, string6);
                    break;
                }
                case 7: {
                    new FloatColumn(table, string6);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    new BlobColumn(table, string6, BlobColumn.BINARY_BLOB);
                    break;
                }
                case -1: {
                    new BlobColumn(table, string6, BlobColumn.STRING_BLOB);
                    break;
                }
                default: {
                    throw new SQLException("Column " + string6 + " of type " + this.colTypes[n] + " is not supported");
                }
            }
            ++n;
        }
    }

    public void close() throws SQLException, IOException {
        this.rs.close();
        this.stmt.close();
        this.con.close();
    }

    public String getCurLine() throws SQLException, IOException {
        return "";
    }

    public void getNextRow(Vector vector, int n) throws SQLException, IOException {
        int n2 = 1;
        while (n2 <= this.numCols) {
            Object object = null;
            switch (this.colTypes[n2]) {
                case -7: 
                case -6: 
                case 4: 
                case 5: {
                    object = new Integer(this.rs.getInt(n2));
                    break;
                }
                case -5: {
                    object = new Long(this.rs.getLong(n2));
                    break;
                }
                case 91: {
                    object = this.rs.getDate(n2);
                    break;
                }
                case 92: {
                    object = this.rs.getTime(n2);
                    break;
                }
                case 93: {
                    object = this.rs.getTimestamp(n2);
                    break;
                }
                case 6: 
                case 8: {
                    object = new Double(this.rs.getDouble(n2));
                    break;
                }
                case 7: {
                    object = new Float(this.rs.getFloat(n2));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    object = this.rs.getObject(n2);
                    break;
                }
                default: {
                    object = this.rs.getString(n2);
                }
            }
            vector.setElementAt(object, n2);
            ++n2;
        }
    }

    public boolean hasMoreRows() throws SQLException, IOException {
        return this.rs.next();
    }
}

