/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.framework;

import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.xml.sax.AttributeList;

public final class XMLAttrList
implements AttributeList {
    private static final int CHUNK_SHIFT = 5;
    private static final int CHUNK_SIZE = 32;
    private static final int CHUNK_MASK = 31;
    private static final int INITIAL_CHUNK_COUNT = 32;
    private static final int ATTFLAG_SPECIFIED = 1;
    private static final int ATTFLAG_LASTATTR = 2;
    private StringPool fStringPool = null;
    private int fCurrentHandle = -1;
    private int fAttributeListHandle = -1;
    private int fAttributeListLength = 0;
    private int fAttrCount = 0;
    private int[][] fAttPrefix = new int[32][];
    private int[][] fAttLocalpart = new int[32][];
    private int[][] fAttName = new int[32][];
    private int[][] fAttURI = new int[32][];
    private int[][] fAttValue = new int[32][];
    private int[][] fAttType = new int[32][];
    private byte[][] fAttFlags = new byte[32][];
    private QName fAttributeQName = new QName();

    public XMLAttrList(StringPool stringPool) {
        this.fStringPool = stringPool;
    }

    public void reset(StringPool stringPool) {
        this.fStringPool = stringPool;
        this.fCurrentHandle = -1;
        this.fAttributeListHandle = -1;
        this.fAttributeListLength = 0;
        this.fAttrCount = 0;
    }

    public int addAttr(int n, int n2, int n3, boolean bl, boolean bl2) throws Exception {
        this.fAttributeQName.setValues(-1, n, n);
        return this.addAttr(this.fAttributeQName, n2, n3, bl, bl2);
    }

    public int addAttr(QName qName, int n, int n2, boolean bl, boolean bl2) throws Exception {
        int n3;
        int n4;
        if (bl2) {
            n4 = this.fCurrentHandle >> 5;
            n3 = this.fCurrentHandle & 0x1F;
            int n5 = this.fCurrentHandle;
            while (n5 < this.fAttrCount) {
                if (this.fStringPool.equalNames(this.fAttName[n4][n3], qName.rawname)) {
                    return -1;
                }
                if (++n3 == 32) {
                    ++n4;
                    n3 = 0;
                }
                ++n5;
            }
        } else {
            n4 = this.fAttrCount >> 5;
            n3 = this.fAttrCount & 0x1F;
        }
        this.ensureCapacity(n4, n3);
        this.fAttPrefix[n4][n3] = qName.prefix;
        this.fAttLocalpart[n4][n3] = qName.localpart;
        this.fAttName[n4][n3] = qName.rawname;
        this.fAttURI[n4][n3] = qName.uri;
        this.fAttValue[n4][n3] = n;
        this.fAttType[n4][n3] = n2;
        this.fAttFlags[n4][n3] = bl ? (byte)1 : 0;
        return this.fAttrCount++;
    }

    public int startAttrList() {
        this.fCurrentHandle = this.fAttrCount;
        return this.fCurrentHandle;
    }

    public void endAttrList() {
        int n = this.fAttrCount - 1;
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        byte[] byArray = this.fAttFlags[n2];
        int n4 = n3;
        byArray[n4] = (byte)(byArray[n4] | 2);
        this.fCurrentHandle = -1;
    }

    public int getAttrPrefix(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttPrefix[n2][n3];
    }

    public int getAttrLocalpart(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttLocalpart[n2][n3];
    }

    public int getAttrName(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttName[n2][n3];
    }

    public void setAttrURI(int n, int n2) {
        if (n < 0 || n >= this.fAttrCount) {
            return;
        }
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        this.fAttURI[n3][n4] = n2;
    }

    public int getAttrURI(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttURI[n2][n3];
    }

    public int getAttValue(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttValue[n2][n3];
    }

    public void setAttValue(int n, int n2) {
        if (n < 0 || n >= this.fAttrCount) {
            return;
        }
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        this.fAttValue[n3][n4] = n2;
    }

    public void setAttType(int n, int n2) {
        if (n < 0 || n >= this.fAttrCount) {
            return;
        }
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        this.fAttType[n3][n4] = n2;
    }

    public int getAttType(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttType[n2][n3];
    }

    public boolean isSpecified(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return true;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return (this.fAttFlags[n2][n3] & 1) != 0;
    }

    public void releaseAttrList(int n) {
        int n2;
        if (n == -1) {
            return;
        }
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        do {
            n2 = (this.fAttFlags[n3][n4] & 2) != 0 ? 1 : 0;
            this.fAttPrefix[n3][n4] = -1;
            this.fAttLocalpart[n3][n4] = -1;
            this.fAttName[n3][n4] = -1;
            this.fAttURI[n3][n4] = -1;
            if ((this.fAttFlags[n3][n4] & 1) != 0) {
                this.fStringPool.releaseString(this.fAttValue[n3][n4]);
            }
            this.fAttValue[n3][n4] = -1;
            if (++n4 != 32) continue;
            ++n3;
            n4 = 0;
        } while (n2 == 0);
        n2 = (n3 << 5) + n4;
        if (this.fAttrCount == n2) {
            this.fAttrCount = n;
        }
    }

    public int getFirstAttr(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        return n;
    }

    public int getNextAttr(int n) {
        if (n < 0 || n + 1 >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        if ((this.fAttFlags[n2][n3] & 2) != 0) {
            return -1;
        }
        return n + 1;
    }

    public AttributeList getAttributeList(int n) {
        this.fAttributeListHandle = n;
        if (this.fAttributeListHandle == -1) {
            this.fAttributeListLength = 0;
        } else {
            int n2 = this.fAttributeListHandle >> 5;
            int n3 = this.fAttributeListHandle & 0x1F;
            this.fAttributeListLength = 1;
            while ((this.fAttFlags[n2][n3] & 2) == 0) {
                if (++n3 == 32) {
                    ++n2;
                    n3 = 0;
                }
                ++this.fAttributeListLength;
            }
        }
        return this;
    }

    public int getLength() {
        return this.fAttributeListLength;
    }

    public String getPrefix(int n) {
        if (n < 0 || n >= this.fAttributeListLength) {
            return null;
        }
        int n2 = this.fAttributeListHandle + n >> 5;
        int n3 = this.fAttributeListHandle + n & 0x1F;
        return this.fStringPool.toString(this.fAttPrefix[n2][n3]);
    }

    public String getLocalpart(int n) {
        if (n < 0 || n >= this.fAttributeListLength) {
            return null;
        }
        int n2 = this.fAttributeListHandle + n >> 5;
        int n3 = this.fAttributeListHandle + n & 0x1F;
        return this.fStringPool.toString(this.fAttLocalpart[n2][n3]);
    }

    public String getName(int n) {
        if (n < 0 || n >= this.fAttributeListLength) {
            return null;
        }
        int n2 = this.fAttributeListHandle + n >> 5;
        int n3 = this.fAttributeListHandle + n & 0x1F;
        return this.fStringPool.toString(this.fAttName[n2][n3]);
    }

    public String getURI(int n) {
        if (n < 0 || n >= this.fAttributeListLength) {
            return null;
        }
        int n2 = this.fAttributeListHandle + n >> 5;
        int n3 = this.fAttributeListHandle + n & 0x1F;
        return this.fStringPool.toString(this.fAttURI[n2][n3]);
    }

    public String getType(int n) {
        if (n < 0 || n >= this.fAttributeListLength) {
            return null;
        }
        int n2 = this.fAttributeListHandle + n >> 5;
        int n3 = this.fAttributeListHandle + n & 0x1F;
        int n4 = this.fAttType[n2][n3];
        if (n4 == this.fStringPool.addSymbol("ENUMERATION")) {
            n4 = this.fStringPool.addSymbol("NMTOKEN");
        }
        return this.fStringPool.toString(n4);
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.fAttributeListLength) {
            return null;
        }
        int n2 = this.fAttributeListHandle + n >> 5;
        int n3 = this.fAttributeListHandle + n & 0x1F;
        return this.fStringPool.toString(this.fAttValue[n2][n3]);
    }

    public String getType(String string) {
        int n = this.fStringPool.addSymbol(string);
        if (n == -1) {
            return null;
        }
        int n2 = this.fAttributeListHandle >> 5;
        int n3 = this.fAttributeListHandle & 0x1F;
        int n4 = 0;
        while (n4 < this.fAttributeListLength) {
            if (this.fStringPool.equalNames(this.fAttName[n2][n3], n)) {
                int n5 = this.fAttType[n2][n3];
                if (n5 == this.fStringPool.addSymbol("ENUMERATION")) {
                    n5 = this.fStringPool.addSymbol("NMTOKEN");
                }
                return this.fStringPool.toString(n5);
            }
            if (++n3 == 32) {
                ++n2;
                n3 = 0;
            }
            ++n4;
        }
        return null;
    }

    public String getValue(String string) {
        int n = this.fStringPool.addSymbol(string);
        if (n == -1) {
            return null;
        }
        int n2 = this.fAttributeListHandle >> 5;
        int n3 = this.fAttributeListHandle & 0x1F;
        int n4 = 0;
        while (n4 < this.fAttributeListLength) {
            if (this.fStringPool.equalNames(this.fAttName[n2][n3], n)) {
                return this.fStringPool.toString(this.fAttValue[n2][n3]);
            }
            if (++n3 == 32) {
                ++n2;
                n3 = 0;
            }
            ++n4;
        }
        return null;
    }

    private boolean ensureCapacity(int n, int n2) {
        try {
            return this.fAttName[n][n2] != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[][] nArrayArray = new int[n * 2][];
            System.arraycopy(this.fAttPrefix, 0, nArrayArray, 0, n);
            this.fAttPrefix = nArrayArray;
            nArrayArray = new int[n * 2][];
            System.arraycopy(this.fAttLocalpart, 0, nArrayArray, 0, n);
            this.fAttLocalpart = nArrayArray;
            nArrayArray = new int[n * 2][];
            System.arraycopy(this.fAttName, 0, nArrayArray, 0, n);
            this.fAttName = nArrayArray;
            nArrayArray = new int[n * 2][];
            System.arraycopy(this.fAttURI, 0, nArrayArray, 0, n);
            this.fAttURI = nArrayArray;
            nArrayArray = new int[n * 2][];
            System.arraycopy(this.fAttValue, 0, nArrayArray, 0, n);
            this.fAttValue = nArrayArray;
            nArrayArray = new int[n * 2][];
            System.arraycopy(this.fAttType, 0, nArrayArray, 0, n);
            this.fAttType = nArrayArray;
            byte[][] byArrayArray = new byte[n * 2][];
            System.arraycopy(this.fAttFlags, 0, byArrayArray, 0, n);
            this.fAttFlags = byArrayArray;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fAttPrefix[n] = new int[32];
        this.fAttLocalpart[n] = new int[32];
        this.fAttName[n] = new int[32];
        this.fAttURI[n] = new int[32];
        this.fAttValue[n] = new int[32];
        this.fAttType[n] = new int[32];
        this.fAttFlags[n] = new byte[32];
        return true;
    }
}

