/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.ABAPStreamDescriptor;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.AsciiABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.AsciiABAPStreamPutval;
import com.sap.dbtech.jdbc.translators.BinaryABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.BinaryABAPStreamPutval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.ReaderInputStream;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StructureABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.UnicodeABAPStreamGetval;
import com.sap.dbtech.jdbc.translators.UnicodeABAPStreamPutval;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class ABAPStreamTranslator
extends DBTechTranslator {
    private static final int STREAMTYPE_ASCII = 1;
    private static final int STREAMTYPE_UNICODE = 2;
    private static final int STREAMTYPE_BYTE = 3;
    private static final int STREAMTYPE_STRUCTURED = 4;
    private DBProcParameterInfo parameterStructure;
    private boolean isUnicodeConnection;
    private int streamtype;

    public ABAPStreamTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.isUnicodeConnection = false;
        this.streamtype = 0;
    }

    public ABAPStreamTranslator(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(n, n2, n3, n4, n5, n6);
        this.isUnicodeConnection = bl;
        this.streamtype = 0;
    }

    protected void putSpecific(DataPart dataPart, Object object) throws SQLException {
        ABAPStreamDescriptor aBAPStreamDescriptor = (ABAPStreamDescriptor)object;
        aBAPStreamDescriptor.putDescriptor(dataPart, this.bufpos);
    }

    protected Object transSpecificForInput(Object object) throws SQLException {
        return null;
    }

    public Object transBinaryStreamForInput(InputStream inputStream, int n) throws SQLException {
        if (this.streamtype == 3) {
            if (inputStream == null) {
                return null;
            }
            return new BinaryABAPStreamPutval(this, inputStream, n);
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.conversion.bytes"));
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (this.streamtype) {
            case 1: {
                if (this.isUnicodeConnection) {
                    return new AsciiABAPStreamPutval(this, StringUtil.bytes_ascii7bit(string), true);
                }
                return new AsciiABAPStreamPutval(this, StringUtil.bytes_iso8859_1(string), false);
            }
            case 2: {
                if (this.isUnicodeConnection) {
                    return new UnicodeABAPStreamPutval(this, string.toCharArray());
                }
                return new AsciiABAPStreamPutval(this, StringUtil.bytes_ascii7bit(string), false);
            }
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.conversion.string"));
    }

    public Object transCharacterStreamForInput(Reader reader, int n) throws SQLException {
        switch (this.streamtype) {
            case 1: {
                if (reader == null) {
                    return null;
                }
                if (this.isUnicodeConnection) {
                    return new AsciiABAPStreamPutval(this, new ReaderInputStream(reader, true), n, true);
                }
                return new AsciiABAPStreamPutval(this, new ReaderInputStream(reader, false), n, false);
            }
            case 2: {
                if (this.isUnicodeConnection) {
                    return new UnicodeABAPStreamPutval(this, reader, n);
                }
                return new AsciiABAPStreamPutval(this, new ReaderInputStream(reader, true), n, false);
            }
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.conversion.string"));
    }

    public void setProcParamInfo(DBProcParameterInfo dBProcParameterInfo) {
        this.parameterStructure = dBProcParameterInfo;
        if (this.parameterStructure != null) {
            if (this.parameterStructure.getMemberCount() == 1) {
                DBProcParameterInfo.StructureElement structureElement = this.parameterStructure.getMember(0);
                if (structureElement.typeName.equals("CHAR")) {
                    if (structureElement.codeType.equals("ASCII")) {
                        this.streamtype = 1;
                        return;
                    }
                    if (structureElement.codeType.equals("BYTE")) {
                        this.streamtype = 3;
                        return;
                    }
                } else if (structureElement.typeName.equals("WYDE")) {
                    this.streamtype = 2;
                    return;
                }
            }
            this.streamtype = 4;
        }
    }

    public boolean isStreamKind() {
        return true;
    }

    public Object transClobForInput(Clob clob) throws SQLException {
        if (this.streamtype == 1 || this.streamtype == 2) {
            if (clob == null) {
                return null;
            }
            Reader reader = clob.getCharacterStream();
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[4096];
            int n = 0;
            do {
                try {
                    n = reader.read(cArray);
                    if (n == -1) continue;
                    stringBuffer.append(cArray, 0, n);
                }
                catch (IOException iOException) {
                    throw new SQLExceptionSapDB("error.stream.sourceread", iOException.getMessage());
                }
            } while (n != -1);
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.transStringForInput(stringBuffer.toString());
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.conversion.string"));
    }

    public Object transBytesForInput(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return this.transBinaryStreamForInput(null, -1);
        }
        return this.transBinaryStreamForInput(new ByteArrayInputStream(byArray), -1);
    }

    public AbstractABAPStreamGetval createGetval() throws SQLException {
        switch (this.streamtype) {
            case 1: {
                return new AsciiABAPStreamGetval(this);
            }
            case 2: {
                if (this.isUnicodeConnection) {
                    return new UnicodeABAPStreamGetval(this);
                }
                return new AsciiABAPStreamGetval(this);
            }
            case 3: {
                return new BinaryABAPStreamGetval(this);
            }
            case 4: {
                return new StructureABAPStreamGetval(this, this.parameterStructure, this.isUnicodeConnection);
            }
        }
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.unknowntype"));
    }

    private AbstractABAPStreamGetval getGetval(SQLParamController sQLParamController) throws SQLException {
        AbstractABAPStreamGetval abstractABAPStreamGetval = sQLParamController.getOMSGetval(this.getColIndex());
        if (abstractABAPStreamGetval == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.nodata"));
        }
        return abstractABAPStreamGetval;
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getString();
    }

    public InputStream getAsciiStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getGetval(sQLParamController).getAsciiStream();
    }

    public BigDecimal getBigDecimal(int n, SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getBigDecimal();
    }

    public InputStream getBinaryStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getGetval(sQLParamController).getBinaryStream();
    }

    public Blob getBlob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getGetval(sQLParamController).getBlob();
    }

    public boolean getBoolean(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getBoolean();
    }

    public byte getByte(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getByte();
    }

    public byte[] getBytes(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getBytes();
    }

    public Reader getCharacterStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getGetval(sQLParamController).getCharacterStream();
    }

    public Clob getClob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getGetval(sQLParamController).getClob();
    }

    public Date getDate(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        return this.getGetval(sQLParamController).getDate(calendar);
    }

    public double getDouble(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getDouble();
    }

    public float getFloat(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getFloat();
    }

    public int getInt(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getInt();
    }

    public long getLong(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getLong();
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getGetval(sQLParamController).getObject();
    }

    public Time getTime(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        return this.getGetval(sQLParamController).getTime(calendar);
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        return this.getGetval(sQLParamController).getTimestamp(calendar);
    }

    public String getBaseTypeName() {
        return this.parameterStructure.getBaseTypeName();
    }

    public String getColumnTypeName() {
        return this.parameterStructure.getSQLTypeName();
    }
}

