/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.ProxyEmitter;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class XMLIndenter
extends ProxyEmitter {
    private int level = 0;
    private int indentSpaces = 3;
    private String indentChars = "                                                          ";
    private boolean sameline = false;
    private boolean afterTag = true;
    private boolean allWhite = true;

    public void startDocument() throws TransformerException {
        String string;
        super.startDocument();
        String string2 = this.outputProperties.getProperty("{http://icl.com/saxon}indent-spaces");
        if (string2 != null) {
            try {
                this.indentSpaces = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                this.indentSpaces = 3;
            }
        }
        this.afterTag = (string = this.outputProperties.getProperty("omit-xml-declaration")) == null || !string.equals("yes") || this.outputProperties.getProperty("doctype-system") != null;
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        if (this.afterTag) {
            this.indent();
        }
        super.startElement(n, attributes, nArray, n2);
        ++this.level;
        this.sameline = true;
        this.afterTag = true;
        this.allWhite = true;
    }

    public void endElement(int n) throws TransformerException {
        --this.level;
        if (this.afterTag && !this.sameline) {
            this.indent();
        }
        super.endElement(n);
        this.sameline = false;
        this.afterTag = true;
        this.allWhite = true;
    }

    public void processingInstruction(String string, String string2) throws TransformerException {
        super.processingInstruction(string, string2);
        this.afterTag = true;
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        int n3 = n;
        while (n3 < n + n2) {
            if (cArray[n3] == '\n') {
                this.sameline = false;
            }
            if (!Character.isWhitespace(cArray[n3])) {
                this.allWhite = false;
            }
            ++n3;
        }
        super.characters(cArray, n, n2);
        if (!this.allWhite) {
            this.afterTag = false;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws TransformerException {
    }

    public void comment(char[] cArray, int n, int n2) throws TransformerException {
        super.comment(cArray, n, n2);
        this.afterTag = true;
    }

    public void endDocument() throws TransformerException {
        super.endDocument();
    }

    private void indent() throws TransformerException {
        int n = this.level * this.indentSpaces;
        while (n > this.indentChars.length()) {
            this.indentChars = this.indentChars + this.indentChars;
        }
        char[] cArray = new char[n + 1];
        cArray[0] = 10;
        this.indentChars.getChars(0, n, cArray, 1);
        super.characters(cArray, 0, n + 1);
        this.sameline = false;
    }
}

