/*
 * Copyright (C) 1992 by Software Research Associates, Inc.
 *	Author:	Y. Kawabe <kawabe@sra.co.jp>
 *
 * Permission to use, copy, modify, and distribute, and sell this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Software Research Associates
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#ifndef nls_charset_h
#define nls_charset_h

#include <NLS/enter-scope.h>
#include <hyperg/OS/enter-scope.h>

class String;
class UniqueString;

/*
 * class CharSetRep
 */

class CharSetRep {
  public:
    CharSetRep(const char*, int, int, int, char);
    ~CharSetRep();

  public:
    const UniqueString& name() const;	// Name of Character Set
    int  bytes() const;		// number of bytes per character
    int  cols() const;		// number of columns
    int  chars() const;		// number of graphic character
    char final() const;		// final charcter of ISO2022 encoding

  private:
    UniqueString	*name_;
    int			bytes_;
    int			cols_;
    int			chars_;
    char		final_;
};

inline const UniqueString& CharSetRep::name () const { return *name_; }
inline int CharSetRep::bytes () const { return bytes_; }
inline int CharSetRep::cols () const { return cols_; }
inline int CharSetRep::chars () const { return chars_; }
inline char CharSetRep::final () const { return final_; }

/*
 * class CharSet
 */

class CharSetRepTable;

class CharSet {
  public:
    enum SorM { Single, Multiple };

  public:
    static CharSet_T ascii () { return 0; }
    static CharSet_T latin () { return 1; }
    static CharSet_T find (const char*);
    static CharSet_T find (const String &);
    static CharSet_T find (enum SorM, int chars, char final);

  public:
    static const CharSetRep* rep (CharSet_T uid) ;
    
  private:
    static void initialize();
    static CharSetRepTable	*table_;
};

#endif
