/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */

// 
//	CDragBarDragTask.cp
// 

#include "CDragBarDragTask.h"
#include "CDragBar.h"
#include "CGWorld.h"

#include "StCaptureView.h"
#include "CEnvironment.h"

#include <Drag.h>

// 
//		
// 

CDragBarDragTask::CDragBarDragTask(
	CDragBar*			inBar,
	const EventRecord& 	inEventRecord)
	:	LDragTask(inEventRecord)
{
	mBar = inBar;
}

// 
//		
// 
									
CDragBarDragTask::~CDragBarDragTask()
{
}

// 
//		
// 

OSErr CDragBarDragTask::DoDrag(void)
{
	if (UEnvironment::HasFeature(env_HasDragMgrImageSupport))
		{
		Boolean bTranslucentFailed = false;
		try
			{
			DoTranslucentDrag();
			}
		catch (...)
			{
			bTranslucentFailed = true;
			}
			
		if (bTranslucentFailed)
			DoNormalDrag();
		}
	else
		DoNormalDrag();
		
	return noErr;
}

// 
//		
// 

void CDragBarDragTask::DoNormalDrag(void)
{
	mBar->StartTracking();
	LDragTask::DoDrag();
	mBar->StopTracking();
}

// 
//		
// 

void CDragBarDragTask::DoTranslucentDrag(void)
{
	StColorState::Normalize();
	mBar->FocusDraw();
	
	Rect theFrame;
	mBar->CalcLocalFrameRect(theFrame);

	CGWorld theOffWorld(theFrame, 0, useTempMem);
	StCaptureView theCaptureView(*mBar);
	theCaptureView.Capture(theOffWorld);

	mBar->FocusDraw();

   	Point theOffsetPoint = topLeft(theFrame);
	::LocalToGlobal(&theOffsetPoint);

	StRegion theTrackMask(theFrame);
	PixMapHandle theMap = ::GetGWorldPixMap(theOffWorld.GetMacGWorld());
	OSErr theErr = ::SetDragImage(mDragRef, theMap, theTrackMask, theOffsetPoint, kDragDarkerTranslucency);
	ThrowIfOSErr_(theErr);
	
	mBar->StartTracking();
	LDragTask::DoDrag();
	mBar->StopTracking();
}

// 
//		
// 

void CDragBarDragTask::AddFlavors(
	DragReference			inDragRef)
{
	// We have to send |flavorNotSaved| or OS8 Finder will crash if you try to drag a bar onto the desktop.
	OSErr theErr = ::AddDragItemFlavor(inDragRef, (ItemReference)this, Flavor_DragBar, mBar, sizeof(CDragBar*),
											flavorSenderOnly | flavorNotSaved);
	ThrowIfOSErr_(theErr);
}

// 
//		
// 

void CDragBarDragTask::MakeDragRegion(
	DragReference		inDragRef,
	RgnHandle			/* inDragRegion */)
{
	
	Rect theLocalBarFrame;
	mBar->FocusDraw();
	mBar->CalcLocalFrameRect(theLocalBarFrame);
	
	Rect theGlobalFrame = theLocalBarFrame;
	::LocalToGlobal(&topLeft(theGlobalFrame));
	::LocalToGlobal(&botRight(theGlobalFrame));
	
	// Get the single item and add this, its rectangle
	ItemReference item;
	::GetDragItemReferenceNumber(inDragRef, 1, &item);
	AddRectDragItem(item, theGlobalFrame);
}






