/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

public class ClassInfo {
    String className;
    int classCount;
    String[] classNames;
    int[] classVersions;
    int fieldCount;
    String[] fieldNames;
    byte[] fieldTypes;

    public ClassInfo(String className) {
        this.className = className;
        this.classNames = new String[8];
        this.classVersions = new int[8];
        this.fieldNames = new String[24];
        this.fieldTypes = new byte[24];
    }

    public void addClass(String className, int version) {
        this.ensureClassCapacity(this.classCount);
        this.classNames[this.classCount] = className;
        this.classVersions[this.classCount] = version;
        ++this.classCount;
    }

    public void addField(String fieldName, byte fieldType) {
        this.ensureFieldCapacity(this.fieldCount);
        this.fieldNames[this.fieldCount] = fieldName;
        this.fieldTypes[this.fieldCount] = fieldType;
        ++this.fieldCount;
    }

    public String className() {
        return this.className;
    }

    public int classCount() {
        return this.classCount;
    }

    public String[] classNames() {
        String[] tmp = new String[this.classCount];
        System.arraycopy(this.classNames, 0, tmp, 0, this.classCount);
        return tmp;
    }

    public int[] classVersions() {
        int[] tmp = new int[this.classCount];
        System.arraycopy(this.classVersions, 0, tmp, 0, this.classCount);
        return tmp;
    }

    public int fieldCount() {
        return this.fieldCount;
    }

    public String[] fieldNames() {
        String[] tmp = new String[this.fieldCount];
        System.arraycopy(this.fieldNames, 0, tmp, 0, this.fieldCount);
        return tmp;
    }

    public byte[] fieldTypes() {
        byte[] tmp = new byte[this.fieldCount];
        System.arraycopy(this.fieldTypes, 0, tmp, 0, this.fieldCount);
        return tmp;
    }

    protected void ensureClassCapacity(int cap) {
        if (cap < this.classNames.length) {
            return;
        }
        int newCap = this.classNames.length == 0 ? 8 : 2 * this.classNames.length;
        while (newCap < cap) {
            newCap = 2 * newCap;
        }
        int oldLen = this.classNames.length;
        String[] newInheritancePath = new String[newCap];
        int[] newClassVersions = new int[newCap];
        System.arraycopy(this.classNames, 0, newInheritancePath, 0, oldLen);
        System.arraycopy(this.classVersions, 0, newClassVersions, 0, oldLen);
        this.classNames = newInheritancePath;
        this.classVersions = newClassVersions;
    }

    protected void ensureFieldCapacity(int cap) {
        int newCap = this.fieldCapacityFor(cap);
        if (newCap < 0) {
            return;
        }
        int oldLen = this.fieldNames.length;
        String[] newFieldNames = new String[newCap];
        byte[] newFieldTypes = new byte[newCap];
        System.arraycopy(this.fieldNames, 0, newFieldNames, 0, oldLen);
        System.arraycopy(this.fieldTypes, 0, newFieldTypes, 0, oldLen);
        this.fieldNames = newFieldNames;
        this.fieldTypes = newFieldTypes;
    }

    public int fieldCapacityFor(int cap) {
        int newCap = 0;
        if (cap < this.fieldNames.length) {
            return -1;
        }
        newCap = this.fieldNames.length == 0 ? 24 : 2 * this.fieldNames.length;
        while (newCap < cap) {
            newCap = 2 * newCap;
        }
        return newCap;
    }
}

