/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.LayoutManager;
import netscape.application.PackConstraints;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class PackLayout
implements LayoutManager,
Codable {
    Hashtable viewConstraints = new Hashtable();
    Vector viewVector = new Vector();
    PackConstraints defaultConstraints;
    static final String VIEWCONSTRAINTS_KEY = "viewConstraints";
    static final String VIEWVECTOR_KEY = "viewVector";
    static final String DEFAULT_CONSTRAINTS_KEY = "defaultConstraints";

    public PackConstraints defaultConstraints() {
        if (this.defaultConstraints == null) {
            this.defaultConstraints = new PackConstraints();
        }
        return this.defaultConstraints;
    }

    public void setDefaultConstraints(PackConstraints constraints) {
        if (!constraints.equals(this.defaultConstraints())) {
            int count = this.viewVector.count();
            int i = 0;
            while (i < count) {
                this.constraintsFor((View)this.viewVector.elementAt(i));
                ++i;
            }
        }
        this.defaultConstraints = constraints;
    }

    public PackConstraints constraintsFor(View aView) {
        if (this.viewConstraints.get(aView) == null) {
            this.setConstraints(aView, this.defaultConstraints());
        }
        return (PackConstraints)this.viewConstraints.get(aView);
    }

    public void addSubview(View aView) {
        this.viewVector.addElementIfAbsent(aView);
    }

    public void setConstraints(View aView, PackConstraints constraints) {
        this.viewVector.addElementIfAbsent(aView);
        this.viewConstraints.put(aView, constraints.clone());
    }

    public void removeSubview(View aView) {
        this.viewConstraints.remove(aView);
        this.viewVector.removeElement(aView);
    }

    public void layoutView(View aView, int deltaWidth, int deltaHeight) {
        int cavityX = 0;
        int cavityY = 0;
        int cavityWidth = aView.bounds.width;
        int cavityHeight = aView.bounds.height;
        Vector sViews = aView.subviews();
        int max = sViews.count();
        int cntx = 0;
        while (cntx < max) {
            int y;
            int x;
            int frameY;
            int frameX;
            int frameHeight;
            int frameWidth;
            View curView = (View)sViews.elementAt(cntx);
            PackConstraints constraints = (PackConstraints)this.viewConstraints.get(curView);
            if (constraints == null) {
                constraints = this.defaultConstraints();
            }
            int side = constraints.side();
            int padx = constraints.padX() * 2;
            int pady = constraints.padY() * 2;
            int ipadx = constraints.internalPadX();
            int ipady = constraints.internalPadY();
            boolean expand = constraints.expand();
            boolean fillx = constraints.fillX();
            boolean filly = constraints.fillY();
            int anchor = constraints.anchor();
            Size preferredSize = this.preferredLayoutSize(curView);
            if (side == 0 || side == 1) {
                frameWidth = cavityWidth;
                frameHeight = preferredSize.height + pady + ipady;
                if (expand) {
                    frameHeight += this.YExpansion(curView, cavityHeight);
                }
                if ((cavityHeight -= frameHeight) < 0) {
                    frameHeight += cavityHeight;
                    cavityHeight = 0;
                }
                frameX = cavityX;
                if (side == 0) {
                    frameY = cavityY;
                    cavityY += frameHeight;
                } else {
                    frameY = cavityY + cavityHeight;
                }
            } else {
                frameHeight = cavityHeight;
                frameWidth = preferredSize.width + padx + ipadx;
                if (expand) {
                    frameWidth += this.XExpansion(curView, cavityWidth);
                }
                if ((cavityWidth -= frameWidth) < 0) {
                    frameWidth += cavityWidth;
                    cavityWidth = 0;
                }
                frameY = cavityY;
                if (side == 2) {
                    frameX = cavityX;
                    cavityX += frameWidth;
                } else {
                    frameX = cavityX + cavityWidth;
                }
            }
            int width = preferredSize.width + ipadx;
            if (fillx || width > frameWidth - padx) {
                width = frameWidth - padx;
            }
            int height = preferredSize.height + ipady;
            if (filly || height > frameHeight - pady) {
                height = frameHeight - pady;
            }
            padx /= 2;
            pady /= 2;
            switch (anchor) {
                case 0: {
                    x = frameX + (frameWidth - width) / 2;
                    y = frameY + pady;
                    break;
                }
                case 1: {
                    x = frameX + frameWidth - width - padx;
                    y = frameY + pady;
                    break;
                }
                case 2: {
                    x = frameX + frameWidth - width - padx;
                    y = frameY + (frameHeight - height) / 2;
                    break;
                }
                case 3: {
                    x = frameX + frameWidth - width - padx;
                    y = frameY + frameHeight - height - pady;
                    break;
                }
                case 4: {
                    x = frameX + (frameWidth - width) / 2;
                    y = frameY + frameHeight - height - pady;
                    break;
                }
                case 5: {
                    x = frameX + padx;
                    y = frameY + frameHeight - height - pady;
                    break;
                }
                case 6: {
                    x = frameX + padx;
                    y = frameY + (frameHeight - height) / 2;
                    break;
                }
                case 7: {
                    x = frameX + padx;
                    y = frameY + pady;
                    break;
                }
                default: {
                    x = frameX + (frameWidth - width) / 2;
                    y = frameY + (frameHeight - height) / 2;
                }
            }
            curView.setBounds(x, y, width, height);
            ++cntx;
        }
    }

    private int XExpansion(View current, int cavityWidth) {
        int curExpand;
        int minExpand = cavityWidth;
        int numExpand = 0;
        int max = this.viewVector.count();
        int x = this.viewVector.indexOf(current);
        while (x < max) {
            View curView = (View)this.viewVector.elementAt(x);
            PackConstraints constraints = (PackConstraints)this.viewConstraints.get(curView);
            if (constraints == null) {
                constraints = this.defaultConstraints();
            }
            int padx = constraints.padX() * 2;
            int ipadx = constraints.internalPadX();
            boolean expand = constraints.expand();
            int side = constraints.side();
            int childWidth = this.preferredLayoutSize((View)curView).width + padx + ipadx;
            if (side == 0 || side == 1) {
                curExpand = (cavityWidth - childWidth) / numExpand;
                if (curExpand < minExpand) {
                    minExpand = curExpand;
                }
            } else {
                cavityWidth -= childWidth;
                if (expand) {
                    ++numExpand;
                }
            }
            ++x;
        }
        curExpand = cavityWidth / numExpand;
        if (curExpand < minExpand) {
            minExpand = curExpand;
        }
        if (minExpand < 0) {
            return 0;
        }
        return minExpand;
    }

    private int YExpansion(View current, int cavityHeight) {
        int curExpand;
        int minExpand = cavityHeight;
        int numExpand = 0;
        int max = this.viewVector.count();
        int x = this.viewVector.indexOf(current);
        while (x < max) {
            View curView = (View)this.viewVector.elementAt(x);
            PackConstraints constraints = (PackConstraints)this.viewConstraints.get(curView);
            if (constraints == null) {
                constraints = this.defaultConstraints();
            }
            int pady = constraints.padY() * 2;
            int ipady = constraints.internalPadY();
            boolean expand = constraints.expand();
            int side = constraints.side();
            int childHeight = this.preferredLayoutSize((View)curView).height + pady + ipady;
            if (side == 2 || side == 3) {
                curExpand = (cavityHeight - childHeight) / numExpand;
                if (curExpand < minExpand) {
                    minExpand = curExpand;
                }
            } else {
                cavityHeight -= childHeight;
                if (expand) {
                    ++numExpand;
                }
            }
            ++x;
        }
        curExpand = cavityHeight / numExpand;
        if (curExpand < minExpand) {
            minExpand = curExpand;
        }
        if (minExpand < 0) {
            return 0;
        }
        return minExpand;
    }

    private Rect containedRect(View target) {
        Rect maxRect = new Rect(0, 0, 0, 0);
        Vector sViews = target.subviews();
        if (sViews == null || sViews.count() < 1) {
            return new Rect(target.bounds.x, target.bounds.y, target.minSize().width, target.minSize().height);
        }
        target.layoutView(0, 0);
        int max = sViews.count();
        int x = 0;
        while (x < max) {
            if (x == 0) {
                maxRect = this.containedRect((View)sViews.elementAt(x));
            }
            Rect tmpBounds = this.containedRect((View)sViews.elementAt(x));
            maxRect.unionWith(tmpBounds);
            ++x;
        }
        return maxRect;
    }

    public Size preferredLayoutSize(View target) {
        Size minSize = target.minSize();
        if (minSize.width != 0 || minSize.height != 0) {
            return minSize;
        }
        Rect aRect = this.containedRect(target);
        return new Size(aRect.x + aRect.width, aRect.y + aRect.height);
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.PackLayout", 2);
        info.addField(VIEWCONSTRAINTS_KEY, (byte)18);
        info.addField(VIEWVECTOR_KEY, (byte)18);
        info.addField(DEFAULT_CONSTRAINTS_KEY, (byte)18);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.viewConstraints = (Hashtable)decoder.decodeObject(VIEWCONSTRAINTS_KEY);
        this.viewVector = (Vector)decoder.decodeObject(VIEWVECTOR_KEY);
        if (decoder.versionForClassName("netscape.application.PackLayout") > 1) {
            this.defaultConstraints = (PackConstraints)decoder.decodeObject(DEFAULT_CONSTRAINTS_KEY);
        }
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(VIEWCONSTRAINTS_KEY, this.viewConstraints);
        encoder.encodeObject(VIEWVECTOR_KEY, this.viewVector);
        encoder.encodeObject(DEFAULT_CONSTRAINTS_KEY, this.defaultConstraints);
    }

    public void finishDecoding() throws CodingException {
    }
}

