/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class CheckButtonImage
extends Image {
    boolean drawsCheckMark;
    static final String DRAWS_CHECK_KEY = "drawsCheckMark";
    private static Bitmap checkBitmap;

    private Bitmap checkBitmap() {
        if (checkBitmap == null) {
            checkBitmap = Bitmap.bitmapNamed("netscape/application/CheckMark.gif");
        }
        return checkBitmap;
    }

    public CheckButtonImage() {
    }

    public CheckButtonImage(boolean drawsCheckMark) {
        this();
        this.drawsCheckMark = drawsCheckMark;
    }

    public void setDrawsCheckMark(boolean flag) {
        this.drawsCheckMark = flag;
    }

    public boolean drawsCheckMark() {
        return this.drawsCheckMark;
    }

    public int width() {
        return 16;
    }

    public int height() {
        return 16;
    }

    public void drawAt(Graphics g, int x, int y) {
        Rect tmpRect = Rect.newRect(x, y, this.width(), this.height());
        BezelBorder.raisedButtonBezel().drawInRect(g, tmpRect);
        g.setColor(Color.lightGray);
        g.fillRect(tmpRect.x + 2, tmpRect.y + 2, tmpRect.width - 4, tmpRect.height - 4);
        if (this.drawsCheckMark) {
            this.checkBitmap().drawCentered(g, tmpRect);
        }
        Rect.returnRect(tmpRect);
    }

    public void drawScaled(Graphics g, int x, int y, int width, int height) {
        Rect tmpRect = Rect.newRect(x, y, width, height);
        BezelBorder.raisedButtonBezel().drawInRect(g, tmpRect);
        g.setColor(Color.lightGray);
        g.fillRect(tmpRect.x + 2, tmpRect.y + 2, tmpRect.width - 4, tmpRect.height - 4);
        if (this.drawsCheckMark) {
            this.checkBitmap().drawCentered(g, x, y, width, height);
        }
        Rect.returnRect(tmpRect);
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.CheckButtonImage", 1);
        info.addField(DRAWS_CHECK_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeBoolean(DRAWS_CHECK_KEY, this.drawsCheckMark);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.drawsCheckMark = decoder.decodeBoolean(DRAWS_CHECK_KEY);
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
    }
}

