/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.client.JDAPMessage;

class LDAPResponseListener {
    private JDAPMessage response;
    private LDAPException exception;
    private boolean responseReceived;
    private boolean exceptionOccured;
    private Thread me;
    private LDAPControl[] controls;
    private LDAPConnection connection;
    private int id;

    public LDAPResponseListener(LDAPConnection conn) {
        this.connection = conn;
        this.reset();
    }

    synchronized JDAPMessage getResponse() throws LDAPException {
        while (!this.responseReceived) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.exceptionOccured) {
            throw this.exception;
        }
        return this.response;
    }

    synchronized void setResponse(JDAPMessage response) {
        this.response = response;
        this.responseReceived = true;
        this.notifyAll();
    }

    synchronized void setException(LDAPException e) {
        this.exceptionOccured = true;
        this.responseReceived = true;
        this.exception = e;
        this.notifyAll();
    }

    boolean isResponseReceived() {
        return this.responseReceived;
    }

    void reset() {
        this.responseReceived = false;
        this.exceptionOccured = false;
        this.me = null;
    }

    void setThread() {
        this.me = Thread.currentThread();
    }

    Thread getThread() {
        return this.me;
    }

    LDAPConnection getConnection() {
        return this.connection;
    }

    int getID() {
        return this.id;
    }

    void setID(int id) {
        this.id = id;
    }
}

