/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPSchemaElement;

public class LDAPAttributeSchema
extends LDAPSchemaElement {
    protected int syntax = 0;
    private boolean single = false;

    protected LDAPAttributeSchema() {
    }

    public LDAPAttributeSchema(String name, String oid, String description, int syntax, boolean single) {
        super(name, oid, description);
        this.attrName = "attributetypes";
        this.syntax = syntax;
        this.single = single;
    }

    public LDAPAttributeSchema(String raw) {
        this.attrName = "attributetypes";
        raw.trim();
        int l = raw.length();
        raw = raw.substring(2, l - 1);
        l = raw.length();
        int ind = raw.indexOf(32);
        this.oid = raw.substring(0, ind);
        char[] ch = new char[l];
        raw = raw.substring(ind + 1, l);
        l = raw.length();
        raw.getChars(0, l, ch, 0);
        ind = 0;
        l = ch.length;
        while (ind < l) {
            String s = "";
            while (ch[ind] == ' ') {
                ++ind;
            }
            int last = ind + 1;
            while (last < l && ch[last] != ' ') {
                ++last;
            }
            if (ind < l && last < l) {
                s = new String(ch, ind, last - ind);
                ind = last;
                if (s.equalsIgnoreCase("SINGLE-VALUE")) {
                    this.single = true;
                    continue;
                }
            } else {
                ind = l;
            }
            while (ind < l && ch[ind] != '\'') {
                ++ind;
            }
            last = ind + 1;
            while (last < l && ch[last] != '\'') {
                ++last;
            }
            if (ind >= last || last >= l) continue;
            String val = new String(ch, ind + 1, last - ind - 1);
            ind = last + 1;
            if (s.equalsIgnoreCase("NAME")) {
                this.name = val;
                continue;
            }
            if (s.equalsIgnoreCase("DESC")) {
                this.description = val;
                continue;
            }
            if (!s.equalsIgnoreCase("SYNTAX")) continue;
            this.syntax = this.syntaxCheck(val);
        }
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean isSingleValued() {
        return this.single;
    }

    protected String internalSyntaxToString() {
        String s = this.syntax == 1 ? "1.3.6.1.4.1.1466.115.121.1.15" : (this.syntax == 2 ? "1.3.6.1.4.1.1466.115.121.1.5" : (this.syntax == 4 ? "1.3.6.1.4.1.1466.115.121.1.26" : (this.syntax == 3 ? "1.3.6.1.4.1.1466.115.121.1.50" : (this.syntax == 5 ? "1.3.6.1.4.1.1466.115.121.1.12" : (this.syntax == 6 ? "1.3.6.1.4.1.1466.115.121.1.27" : "unknown")))));
        return s;
    }

    public String getValue() {
        String s = "( " + this.oid + " NAME '" + this.name + "' DESC '" + this.description + "' SYNTAX '";
        s = String.valueOf(s) + this.internalSyntaxToString();
        s = String.valueOf(s) + "' ";
        if (this.single) {
            s = String.valueOf(s) + "SINGLE-VALUE ";
        }
        s = String.valueOf(s) + ')';
        return s;
    }

    protected String syntaxToString() {
        String s = this.syntax == 1 ? "case-insensitive string" : (this.syntax == 2 ? "binary" : (this.syntax == 6 ? "integer" : (this.syntax == 4 ? "case-exact string" : (this.syntax == 3 ? "telephone" : (this.syntax == 5 ? "distinguished name" : "unknown")))));
        return s;
    }

    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid + "; Type: ";
        s = String.valueOf(s) + this.syntaxToString();
        s = String.valueOf(s) + "; Description: " + this.description + "; ";
        s = this.single ? String.valueOf(s) + "single-valued" : String.valueOf(s) + "multi-valued";
        return s;
    }

    protected int syntaxCheck(String syntax) {
        int i = 0;
        if (syntax.equals("1.3.6.1.4.1.1466.115.121.1.15")) {
            i = 1;
        } else if (syntax.equals("1.3.6.1.4.1.1466.115.121.1.5")) {
            i = 2;
        } else if (syntax.equals("1.3.6.1.4.1.1466.115.121.1.26")) {
            i = 4;
        } else if (syntax.equals("1.3.6.1.4.1.1466.115.121.1.27")) {
            i = 6;
        } else if (syntax.equals("1.3.6.1.4.1.1466.115.121.1.50")) {
            i = 3;
        } else if (syntax.equals("1.3.6.1.4.1.1466.115.121.1.12")) {
            i = 5;
        }
        return i;
    }
}

