/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import netscape.plugin.composer.io.Comment;
import netscape.plugin.composer.io.Entity;
import netscape.plugin.composer.io.FooStringBuffer;
import netscape.plugin.composer.io.SlidingBuffer;
import netscape.plugin.composer.io.Tag;
import netscape.plugin.composer.io.Text;
import netscape.plugin.composer.io.Token;

public class LexicalStream {
    private SlidingBuffer in;
    private FooStringBuffer buffer;
    private static final String NEWLINE = new String("\n");
    private boolean bHaveClosedStream;

    public LexicalStream(String in) {
        this(new CharArrayReader(in.toCharArray()));
    }

    public LexicalStream(Reader in) {
        this.in = new SlidingBuffer(in);
    }

    private int read() throws IOException {
        return this.in.read();
    }

    private boolean lookAhead(char c) throws IOException {
        return this.in.lookAhead(c);
    }

    private boolean lookAhead(String s) throws IOException {
        return this.in.lookAhead(s);
    }

    private boolean lookAhead(String s, boolean ignoreCase) throws IOException {
        return this.in.lookAhead(s, ignoreCase);
    }

    private boolean eatNewline() throws IOException {
        return this.in.eatNewline();
    }

    private boolean eatWhiteSpace() throws IOException {
        return this.in.eatWhiteSpace();
    }

    public Token next() throws IOException {
        int c;
        while ((c = this.read()) >= 0) {
            if (c == 38) {
                if (this.buffer != null) {
                    this.in.unread(1);
                    break;
                }
                FooStringBuffer buf = new FooStringBuffer();
                this.parseEntity(buf);
                return new Entity(buf);
            }
            if (c == 60) {
                if (this.buffer != null) {
                    this.in.unread(1);
                    break;
                }
                if (this.in.lookAhead('/')) {
                    return this.parseTag(false);
                }
                if (this.in.lookAhead('!')) {
                    return this.parseComment();
                }
                return this.parseTag(true);
            }
            if (c == 13) {
                if (this.buffer != null) {
                    this.in.unread(1);
                    break;
                }
                this.in.lookAhead('\n');
                return new Text(NEWLINE);
            }
            if (c == 10) {
                if (this.buffer != null) {
                    this.in.unread(1);
                    break;
                }
                return new Text(NEWLINE);
            }
            if (this.buffer == null) {
                this.buffer = new FooStringBuffer();
            }
            this.buffer.append((char)c);
        }
        if (this.buffer != null) {
            String rv = this.buffer.toString();
            this.buffer = null;
            return new Text(rv);
        }
        if (!this.bHaveClosedStream) {
            this.in.close();
            this.bHaveClosedStream = true;
        }
        return null;
    }

    private boolean isWhitespace(char c) {
        return Character.isSpace(c);
    }

    private Token parseTag(boolean open) throws IOException {
        int c;
        FooStringBuffer name = new FooStringBuffer();
        while ((c = this.read()) >= 0 && c != 62 && !this.isWhitespace((char)c)) {
            name.append((char)c);
        }
        if (name.length() == 0) {
            name.append('<');
            if (!open) {
                name.append('/');
            }
            if (c >= 0) {
                name.append((char)c);
            }
            return new Text(name.toString());
        }
        Tag tag = new Tag(name.toString(), open);
        if (c == 62) {
            return tag;
        }
        while ((c = this.read()) >= 0 && c != 62) {
            if (this.isWhitespace((char)c)) continue;
            this.in.unread(1);
            this.parseTagAttribute(tag);
        }
        return tag;
    }

    private void parseTagAttribute(Tag tag) throws IOException {
        int c;
        FooStringBuffer name = new FooStringBuffer();
        while ((c = this.read()) >= 0) {
            if (c == 62 || c == 61) {
                this.in.unread(1);
                break;
            }
            if (this.isWhitespace((char)c)) break;
            name.append((char)c);
        }
        if (name.length() == 0) {
            return;
        }
        this.eatWhiteSpace();
        c = this.read();
        FooStringBuffer value = null;
        if (c != 61) {
            this.in.unread(1);
        } else {
            this.eatWhiteSpace();
            c = this.read();
            if (c >= 0) {
                if (c == 62) {
                    this.in.unread(1);
                } else if (c == 39 || c == 34) {
                    value = this.parseQuotedString(c);
                } else {
                    value = new FooStringBuffer();
                    value.append((char)c);
                    while ((c = this.read()) >= 0) {
                        if (c == 62) {
                            this.in.unread(1);
                            break;
                        }
                        if (this.isWhitespace((char)c)) break;
                        value.append((char)c);
                    }
                }
            }
        }
        tag.addAttribute(name.toString(), value != null ? value.toString() : null);
    }

    private FooStringBuffer parseQuotedString(int stop) throws IOException {
        int c;
        FooStringBuffer out = new FooStringBuffer();
        while ((c = this.read()) >= 0) {
            if (c == 38) {
                if (this.in.peek() == 123) {
                    this.read();
                    this.parseJavaScriptEntity(out);
                    continue;
                }
                this.parseEntity(out);
                continue;
            }
            if (c == stop) break;
            out.append((char)c);
        }
        return out;
    }

    private Comment parseComment() throws IOException {
        int c;
        FooStringBuffer out = new FooStringBuffer();
        boolean fancyTerminator = false;
        if (this.in.lookAhead('-')) {
            if (this.in.lookAhead('-')) {
                fancyTerminator = true;
            } else {
                out.append('-');
            }
        }
        while ((c = this.read()) >= 0) {
            if (fancyTerminator) {
                if (c == 45 && this.in.lookAhead('-')) {
                    if (this.in.lookAhead('>')) break;
                    out.append("--");
                }
            } else if (c == 62) break;
            out.append((char)c);
        }
        if (fancyTerminator) {
            return new Comment("--" + out + "--");
        }
        return new Comment(out);
    }

    private void parseEntity(FooStringBuffer out) throws IOException {
        int c;
        while ((c = this.read()) >= 0 && c != 59) {
            if (this.isWhitespace((char)c)) {
                this.in.unread(1);
                return;
            }
            out.append((char)c);
        }
    }

    private void parseJavaScriptEntity(FooStringBuffer out) throws IOException {
        int c;
        int count = 1;
        while ((c = this.read()) >= 0) {
            if (c == 39 || c == 34) {
                this.parseJavaScriptQuotedString(out, c);
                continue;
            }
            if (c == 123) {
                out.append((char)c);
                ++count;
                continue;
            }
            if (c == 125) {
                if (--count == 0) {
                    this.in.lookAhead(';');
                    return;
                }
                out.append((char)c);
                continue;
            }
            if (c == 47) {
                c = this.read();
                if (c < 0) break;
                if (c == 42) {
                    this.parseCComment(out);
                    continue;
                }
                if (c == 47) {
                    this.parseEOLComment(out);
                    continue;
                }
                out.append('/');
                out.append((char)c);
                continue;
            }
            out.append((char)c);
        }
    }

    private void parseJavaScriptQuotedString(FooStringBuffer out, int stop) throws IOException {
        int c;
        out.append((char)stop);
        while ((c = this.read()) >= 0) {
            out.append((char)c);
            if (c == 92) {
                c = this.read();
                if (c < 0) break;
                out.append((char)c);
                continue;
            }
            if (c != stop) continue;
            return;
        }
    }

    private void parseCComment(FooStringBuffer out) throws IOException {
        int c;
        out.append("/*");
        while ((c = this.read()) >= 0) {
            out.append((char)c);
            if (c != 42) continue;
            c = this.read();
            if (c < 0) break;
            out.append((char)c);
            if (c != 47) continue;
            return;
        }
    }

    private void parseEOLComment(FooStringBuffer out) throws IOException {
        int c;
        out.append("//");
        while ((c = this.read()) >= 0) {
            out.append((char)c);
            if (c != 10 && c != 13) continue;
            out.append((char)c);
            return;
        }
    }
}

