
# Description:  Newer IRC servers support a moderated channel (&SERVERS)
#               for server notices. Sometimes (especially on larger
#               irc-networks) you can see there splitting and rejoining
#               servers.
#
#               This file includes procedures which observe the traffic
#               on channel `&SERVERS' to show you the servers actually
#               splitted from that server you are connected to.
#
# Date:         10.03.98
# Author:       Andreas Gelhausen, atte@gecko.north.de
#
# Changes:      10.03.98  Small bug fixed. (Error: can't read
#                         "on_args(to)": no such element in array)
#               03.03.98  Now this script can automatically be loaded
#                         from tkirc (~.tkirc/autoload/) and you
#                         don't need to change your tkircrc!
#               06.02.98  Channel `&servers' can be observed without an
#                         additional window for its traffic. =:^)
#
# Install:
#               1. copy this file to `~/.tkirc/autoload/splits.tcl'
#               2. reload your tkircrc or restart tkirc
#
# Usage:
#               1. select entry `observ &servers' within menu `Private'
#                  and wait what's happening


# geometry_splitted: This variable allows you to set the geometry of 
#          your split-window.
global geometry_splitted
#set geometry_splitted "499x121+552+612"

proc on_leave_splits { } {
  global on_args nickname splitted
  if {[strcmp "$on_args(channel)" "&SERVERS"] == 0} {
    if {[strcmp "$nickname" "$on_args(nick)"] == 0} {
      if {[info exists splitted(window)]} {
        CloseMainWindow $splitted(window) ; unset splitted(window)
      }
    }
  }
}

proc on_menucreate_splits { } {
  global on_args
  $on_args(path).private.menu add command -label "observe &servers" \
      -command "ServerSplits window"
}

proc on_servernotice_splits { } {
  global on_args

  if {![strcmp "$on_args(to)" "&SERVERS"] && ![strcmp "" "$on_args(nick)"]} {
    if {[strmatch "Received SERVER *" "$on_args(rest)"]} {
      ServerSplits update RECEIVED_SERVER
    } elseif {[strmatch "Received SQUIT *" "$on_args(rest)"]} {
      ServerSplits update RECEIVED_SQUIT
    } elseif {[strmatch "Sending SERVER *" "$on_args(rest)"]} {
      ServerSplits update SENDING_SERVER
    } elseif {[strmatch "Sending SQUIT *" "$on_args(rest)"]} {
      ServerSplits update SENDING_SQUIT
    }
  }
}

proc on_364_splits { } {
  global on_args splitted

  set server "[lIndex "$on_args(line)" 3]"
  set len "[llength "$splitted(servers)"]"
  for {set k 0} {$k < $len} {incr k} {
    if {[strmatch "[lindex "$splitted(servers)" $k]" "$server"] \
     || [strmatch "$server" "[lindex "$splitted(servers)" $k]"]} {
      foreach x "dates servers messages" {
	set splitted($x) "[lreplace "$splitted($x)" $k $k]"
      }
      if {[winfo exists $path] && !$splitted(frozen)} {
	$path.list.entries delete $k
      }
    }
  }
}

global splitted
if ![info exists splitted] {
  foreach x "dates servers messages" {
    set splitted($x) ""
  }
}

proc ServerSplits {command args} {
  global on_args splitted chan win crapwindow margin

  if [info exists splitted(window)] {
    set path "[GetPathFromNum $splitted(window)]"
  }

  switch -- "[string tolower "$command"]" {
    "update" {
      set server [lIndex "$on_args(rest)" 2]
      global filternext ; set filternext 1
      if {[strmatch "*_SQUIT" "$args"]} {
	if {[strcmp "RECEIVED_SQUIT" "$args"] == 0} {
	  set cut 5
	} else {
	  # SENDING_SQUIT
	  set cut 3
        }
	set k [lsearch "$splitted(servers)" "[expand "$server"]"]
	if {$k != -1} {
	  set splitted(dates) "[lreplace "$splitted(dates)" $k $k]"
	  set splitted(servers) "[lreplace "$splitted(servers)" $k $k]"
	  set splitted(messages) "[lreplace "$splitted(messages)" $k $k]"
	  if {[winfo exists $path] && !$splitted(frozen)} {
	    $path.list.entries delete $k
	  }
	}
	lappend splitted(dates) "[longdate]"
	lappend splitted(servers) "$server"
	lappend splitted(messages) "[cutwords "$on_args(rest)" $cut]"
	if {[winfo exists $path] && !$splitted(frozen)} {
	  set end "[lindex "[$path.list.entries yview]" 1]"
	  $path.list.entries insert end "[longdate]  $server  [cutwords "$on_args(rest)" $cut]"
	  if {$end == 1} {
	    $path.list.entries yview end
	  }
	}
      } elseif {[strmatch "*_SERVER" "$args"]} {
	# RECEIVED_SERVER & SENDING_SERVER
	set len "[llength "$splitted(servers)"]"
	for {set k 0} {$k < $len} {incr k} {
	  if {[strmatch "[lindex "$splitted(servers)" $k]" "$server"] \
	   || [strmatch "$server" "[lindex "$splitted(servers)" $k]"]} {
	    foreach x "dates servers messages" {
	      set splitted($x) "[lreplace "$splitted($x)" $k $k]"
	    }
	    if {[winfo exists $path] && !$splitted(frozen)} {
	      $path.list.entries delete $k
	    }
	  }
	}
      }
    }

    "delete" {
      set i 0
      foreach k "[$path.list.entries curselection]" {
	set k [expr $k-$i]
	foreach x "dates servers messages" {
	  set splitted($x) "[lreplace "$splitted($x)" $k $k]"
	}
	$path.list.entries delete $k
	incr i
      }
    }

    "confirm" {
      if {[llength "[$path.list.entries curselection]"] > 1} {
        print2crap "+++ Confirming splits through `/links <server>' ..."
      } else {
        print2crap "+++ Executing `/links $tmp' ..."
      }
      foreach k "[$path.list.entries curselection]" {
        set tmp "[lIndex "[$path.list.entries get $k]" 2]"
        send2irc "/links $tmp"
      }
    }

    "clear" {
      foreach x "dates servers messages" {
	set splitted($x) ""
      }
      $path.list.entries delete 0 end
    }

    "save" {
      if {[string length "$args"] == 0} {
        FileRequester " Please select the file to save the \nsplitted servers in!" "Save" "ServerSplits save \:file" "" ""
        return
      }
      set file "[OpenFile "$args" a]"
      if {[string length "$file"]} {
        set ulen [llength "$splitted(servers)"]
        for {set i 0} {$i < $ulen} {incr i} {
          puts $file "[$path.list.entries get $i]"
        }
        close $file
        set margin(text) "note"
        print2crap " All splitted servers saved to file `$args'"
      }
    }

    "freeze" {
      if {$splitted(frozen)} {
	$path.buttons.delete configure -state disabled
      } else {
	$path.buttons.delete configure -state normal
	set end "[lindex "[$path.list.entries yview]" 1]"
	    
	$path.list.entries delete 0 end
	set slen [llength "$splitted(servers)"]
	for {set i 0} {$i < $slen} {incr i} {
	  $path.list.entries insert end "[lindex "$splitted(dates)" $i]  [lindex "$splitted(servers)" $i]  [lindex "$splitted(messages)" $i]"
	}
	if {$end == 1} {
	  $path.list.entries yview end
	}
      }
    }

    "window" {
      if {![info exists splitted(window)]} {
	set splitted(window) [MainWindow -5]
	lappend chan(tojoin) "&servers"
	lappend win(tojoin) "$splitted(window)"
	send2irc "/join &servers"
      }

      set path "[GetPathFromNum $splitted(window)]"
      if [catch {toplevel $path -class tkirc-request}] {
	raise $path
      } else {
	global geometry_splitted
	if {[info exists geometry_splitted]} {
	  wm geometry $path $geometry_splitted
	}
	set theend "CloseMainWindow $splitted(window) ; unset splitted(window)"
	wm title $path " tkirc: splitted servers (&servers) "
	wm protocol $path WM_DELETE_WINDOW "$theend"
	bind $path <Escape> "$theend"
	    
	set frame $path.buttons
	frame $frame
	pack $frame -fill x -pady 2 -side bottom
	button $frame.confirm -text "Confirm" -command "ServerSplits confirm"
	button $frame.delete -text "Delete" -command "ServerSplits delete"
	button $frame.clear -text "Clear list" -command "ServerSplits clear"
	button $frame.save -text "Save list" -command "ServerSplits save"
	button $frame.close -text "Close" -command "$theend"
	pack $frame.confirm $frame.delete -side left
	pack $frame.close $frame.save $frame.clear -side right
	checkbutton $frame.freeze -text "frozen" -variable splitted(frozen) \
	  -command "ServerSplits freeze"
	pack $frame.freeze -anchor c
	    
	frame $path.list -bd 0
	pack $path.list -expand true -fill both -pady 0 -ipady 0
	listbox $path.list.entries -width 12 -selectmode extended \
	  -relief raised -exportselection false \
	  -yscrollcommand "$path.list.scroll set"
	scrollbar $path.list.scroll -width 10 -orient vertical \
	  -command [list $path.list.entries yview]
	pack $path.list.entries -expand true -side left -fill both
	pack $path.list.scroll -side left -fill y
	bind $path.list.entries <Double-Button-1> "ServerSplits confirm"
	    
	$path.list.entries delete 0 end
	set slen [llength "$splitted(servers)"]
	for {set i 0} {$i < $slen} {incr i} {
	  $path.list.entries insert end "[lindex "$splitted(dates)" $i]  [lindex "$splitted(servers)" $i]  [lindex "$splitted(messages)" $i]"
	}
      }
    }
  }
}
