/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  udp.h
 * Purpose: Definitions for implementing the user datagram protocol
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Definition of UDP header
 */
struct udphdr {
	unsigned short udp_source;
	unsigned short udp_dest;
	unsigned short udp_len;
	unsigned short udp_check;
};



/*
 **************************************************************************
 *
 * Maximum size for user datagrams. Note: this assumes no options in the
 * IP header
 */
#define UDP_SEND_SIZE	(IP_SEND_SIZE - sizeof(struct iphdr) - \
							sizeof(struct udphdr))



/*
 **************************************************************************
 *
 * Routines in the UDP module:
 */

/* Initialize UDP layer */
extern int init_udp __P((void));

/* Open a UDP socket */
extern int udp_open __P((t_ipaddr daddr, int source, int dest));

/* Read from a UDP socket */
extern int udp_read __P((char *buf, int bufsize, int timeout, char abortch));

/* Write to a UDP socket */
extern int udp_write __P((char *buf, int writelen));

