// Angle:  abstraction to partially alleviate degrees versus radians debate.
// All angles are "normalized" to the 0-2pi rad (0-360 degree) range.
// Last modified by DWF 1997-10-03

/*
    Copyright (C) 1997  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class Angle {
protected:

  // The preferred unit is radians since that is what is supported
  // most efficiently by libm.
  double radians;

  void normalize();

public:
  enum units {DEGREES, RADIANS};
  Angle ();
  Angle (units u, double v);

  // Return value in whichever units.
  double deg();
  double rad();

  // Pretty-print degrees with specified number of digits after decimal.
  // Uses static internal buffer.  Field width is precision plus 4 if
  // precision is greater than 0; if precision is 0, width is 3.
  Dstr &ppdeg (unsigned precision);

  // Operations.
  Angle &operator+= (Angle a);
  Angle &operator-= (Angle a);
  Angle &operator*= (double a);
};

class Degrees: public Angle {
public:
  Degrees (double v);
};

class Radians: public Angle {
public:
  Radians (double v);
};

// This gives degrees with decimals (not degrees/minutes/seconds).
// It is the same as ppdeg(2).
ostream &operator<< (ostream &out, Angle v);

// Operations.
Angle operator+ (Angle a, Angle b);
Angle operator- (Angle a, Angle b);
Angle operator* (double a, Angle b);
Angle operator* (Angle a, double b);
int operator> (Angle a, Angle b);
int operator< (Angle a, Angle b);
int operator>= (Angle a, Angle b);
int operator<= (Angle a, Angle b);
int operator== (Angle a, Angle b);
int operator!= (Angle a, Angle b);

// Trig functions.
double sin (Angle a);
double cos (Angle a);
double tan (Angle a);
double cot (Angle a);
