/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: init_colors.c,v 1.2 1998/03/19 13:33:41 lance Exp $ */
#include <stdio.h>
#include <math.h>
#include <assert.h>
#include <X11/Xlib.h> 
#include <X11/Xcms.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Xaw/AsciiText.h>

#include "data.h"
#include "xwin.h"

#define NUM_COLORS 12
#define V1   0.3
#define V2   0.8

unsigned long MakeRGBColor(Display *dpy, Colormap cmap,
			   double r, double g,double b)
{
  XcmsColor color;
  color.format = XcmsRGBiFormat;
  color.spec.RGBi.red = r;
  color.spec.RGBi.green = g;
  color.spec.RGBi.blue = b;
  if(XcmsAllocColor(dpy,cmap,&color,XcmsRGBiFormat) == XcmsFailure)
    return (unsigned long) NULL;
  return color.pixel;
}

/* see /usr/lib/X11/rgb.txt for list of color names 
 */
unsigned long GetNamedColor(Display *dpy, Colormap cmap, char *name)
{
  XColor alloc, exact;

  if( XAllocNamedColor( dpy, cmap, name, &alloc, &exact))
    return alloc.pixel;
  else
    return (unsigned long) NULL;
}

/* returns the number of colors that it got
 * n is the number of colors requested
 */

static int SelectNamedColors(Display *dpy, Colormap cmap,
		       unsigned long *pix, int n)
{
  int i;
  unsigned long null;

  null = (unsigned long) NULL;

  i = 0;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"magenta")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"red1")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap, "green1")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"blue1")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"yellow1")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"cyan")))
    return i;

  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"coral1")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"DarkOrchid1")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"orange1")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"plum1")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"RosyBrown")))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = GetNamedColor(dpy,cmap,"salmon3")))
    return i; /** that's 12 colors **/
  i++; if(i == n) return n;
  return i;
}

  

/* returns the number of colors that it got
 * n is the number of colors requested
 */
static int SelectColor(Display *dpy, Colormap cmap,
		       unsigned long *pix, int n)
{
  int i;
  unsigned long null;

  null = (unsigned long) NULL;

  i = 0;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,1.0,0.0,1.0)))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,0.0,1.0,0.0)))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,1.0,0.0,0.0)))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,0.0,0.0,1.0)))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,1.0,1.0,0.0)))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,0.0,1.0,1.0)))
    return i;

  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,1.0,V1,V1)))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,V1,1.0,V1)))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,V1,V1,1.0)))
    return i;

  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,V2,V1,V2)))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,V1,V2,V2)))
    return i;
  i++; if(i == n) return n;
  if(null == (pix[i] = MakeRGBColor(dpy,cmap,V2,V2,V1)))
    return i; /** that's 12 colors **/
  i++; if(i == n) return n;
  return i;
}

/* stupid RainBow color function */
static double f(double x)
{
  long j;
  double a;
  
  a = (x>0.0)?x:-x;

  j = a;
  a -= j;

  if(j & 1)
    a = (1.0-a);
  return a;
}

/* returns the number of colors that it got
 * n is the number of colors requested
 */
static int RainBow(Display *dpy, Colormap cmap,
		       unsigned long *pix, int n)
{
  int i;
  double w,r,g,b;

  w = 2.0/n;      
  for(i=0;i<n;i++)
    {
      r = f(w*i + 1.0); r *= r; 
      g = f(w*i + 0.3333333333*2.0 +1.0); g *=g;
      b = f(w*i + 0.6666666667*2.0 +1.0);b *= b;
      if((unsigned long) NULL == (pix[i] = MakeRGBColor(dpy,cmap,r,g,b)))
	return i;
    }
  return n;
}


/* if this function fails to get color by using XcmsAllocColor()
 * it makes the plots black and white.  I should get fancyer than
 * this and try other X color routines besides XcmsAllocColor();
 * but I don't have the hardware/software to test other X color routines.
 * No other X color routines work on my machine.
 */

void init_colors(PlotXwins *win, Plot *plot)
{
  int i,n;
  Pixel pix;

  assert((plot->point_color=(unsigned long *)malloc(
              sizeof(unsigned long)*plot->num_plots))!=NULL);
  assert((plot->line_color=(unsigned long *)malloc(
	      sizeof(unsigned long)*plot->num_plots))!=NULL);
  n=0;
  if((plot->num_plots > NUM_COLORS) && (!(plot->flag & BLACK_WHITE)))
    {
      if((n = RainBow(win->display,
		  DefaultColormap(win->display,win->screen_number),
		 plot->point_color,plot->num_plots) != plot->num_plots) )
	{
	  fprintf(stderr,"quickplot WARNING: Can't allocate %d colors for plots: switching to BLACK and WHITE mode\n",plot->num_plots - n);
	  plot->flag |= BLACK_WHITE;
	}
    }
  else if((plot->num_plots <= NUM_COLORS) && !(plot->flag & BLACK_WHITE))
    {
      n = SelectColor(win->display,
	       DefaultColormap(win->display,win->screen_number),
		 plot->point_color,plot->num_plots);
    }
  if((plot->num_plots <= NUM_COLORS) &&
     (n != plot->num_plots) && 
     !(plot->flag & BLACK_WHITE)  )
    {
      if((plot->num_plots-n) != (n += SelectNamedColors(win->display,
		       DefaultColormap(win->display,win->screen_number),
			     &((plot->point_color)[n]),plot->num_plots-n)))
	fprintf(stderr,"quickplot WARNING: Can't allocate %d colors for plots: switching to BLACK and WHITE mode\n",plot->num_plots - n);
    }

  /***** get backgroundColor ******/
  XtVaGetValues(win->plotWig, XtNbackground, &pix, NULL);
  win->backgroundColor = pix;

  if(n != plot->num_plots) /* it's going to be black and white */
    {
      pix = (pix == BlackPixel(win->display,win->screen_number))?
	WhitePixel(win->display, win->screen_number):
	BlackPixel(win->display, win->screen_number);
      for(i=n;i<plot->num_plots;i++)
	(plot->point_color)[i] = pix;
    }
  /* make line colors the same as point colors for now */
  for(i=0;i<plot->num_plots;i++)
    	  (plot->line_color)[i] = (plot->point_color)[i];

}
